/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockFallsSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        for (String event : events) {
            Matcher m = Pattern.compile("on (m@)?\\w+ falls", 2).matcher(event);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Block Falls SmartEvent.");
    }

    @Override
    public void breakDown() {
        EntityChangeBlockEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void onBlockPhysics(EntityChangeBlockEvent event) {
        if (event.getBlock().getType().hasGravity() && event.getBlock().getRelative(BlockFace.DOWN).getType().equals((Object)Material.AIR)) {
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            context.put("location", new dLocation(event.getBlock().getLocation()));
            List<String> determinations = OldEventManager.doEvents(Arrays.asList("block falls", dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData()).identifySimple() + " falls"), new BukkitScriptEntryData(null, null), context, true);
            for (String determination : determinations) {
                if (!determination.equalsIgnoreCase("CANCELLED")) continue;
                event.setCancelled(true);
            }
        }
    }
}

