/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockPhysicsSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        for (String event : events) {
            Matcher m = Pattern.compile("on (m@)?\\w+ physics( in (cu@)?\\w+)?", 2).matcher(event);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Block Physics SmartEvent.");
    }

    @Override
    public void breakDown() {
        BlockPhysicsEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        ArrayList<String> events = new ArrayList<String>();
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dLocation block = new dLocation(event.getBlock().getLocation());
        dMaterial mat = dMaterial.getMaterialFrom(block.getBlock().getType(), block.getBlock().getData());
        context.put("location", block);
        context.put("new_material", dMaterial.getMaterialFrom(event.getChangedType()));
        events.add("block physics");
        events.add(mat.identifySimple() + " physics");
        List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(block);
        dList cuboid_context = new dList();
        for (dCuboid cuboid : cuboids) {
            events.add("block physics in " + cuboid.identifySimple());
            events.add(mat.identifySimple() + " physics in " + cuboid.identifySimple());
            cuboid_context.add(cuboid.identify());
        }
        context.put("cuboids", cuboid_context);
        String Determination = BukkitWorldScriptHelper.doEvents(events, null, null, context, true);
        if (Determination.equalsIgnoreCase("CANCELLED")) {
            event.setCancelled(true);
        }
    }
}

