/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dChunk;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkLoadSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        for (String event : events) {
            Matcher m = Pattern.compile("on chunk loads for the first time( in (w@)?\\w+)?", 2).matcher(event);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Chunk Load SmartEvent.");
    }

    @Override
    public void breakDown() {
        ChunkLoadEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!event.isNewChunk()) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("chunk", new dChunk(event.getChunk()));
        context.put("world", world);
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("chunk loads for the first time", "chunk loads for the first time in " + world.identify()), null, null, context, true);
    }
}

