/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dChunk;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkUnloadSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        for (String event : events) {
            Matcher m = Pattern.compile("on chunk unloads( in (w@)?\\w+)?", 2).matcher(event);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Chunk Unload SmartEvent.");
    }

    @Override
    public void breakDown() {
        ChunkUnloadEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void onChunkLoad(ChunkUnloadEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("chunk", new dChunk(event.getChunk()));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("chunk unloads", "chunk unloads " + world.identify()), null, null, context, true);
        if (determination.equalsIgnoreCase("cancelled")) {
            event.setCancelled(true);
        }
    }
}

