/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityDamageSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        for (String event : events) {
            Matcher m = Pattern.compile("on (e@)?\\w+ (damaged by|damages|killed by|kills|damaged|killed)( \\w+)?", 2).matcher(event);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Entity Damage SmartEvent.");
    }

    @Override
    public void breakDown() {
        EntityDamageEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void entityDamage(EntityDamageEvent event) {
        String determination;
        dPlayer player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        String cause = event.getCause().name();
        context.put("entity", entity.getDenizenObject());
        context.put("damage", new Element(event.getDamage()));
        context.put("cause", new Element(event.getCause().name()));
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
        } else if (entity.isPlayer()) {
            player = new dPlayer(entity.getPlayer());
        }
        boolean isFatal = false;
        if (entity.isValid() && entity.isLivingEntity() && event.getDamage() >= entity.getLivingEntity().getHealth()) {
            isFatal = true;
        }
        ArrayList<String> events = new ArrayList<String>();
        events.add("entity damaged");
        events.add("entity damaged by " + cause);
        events.add(entity.identifyType() + " damaged");
        events.add(entity.identifyType() + " damaged by " + cause);
        events.add(entity.identifySimple() + " damaged");
        events.add(entity.identifySimple() + " damaged by " + cause);
        if (isFatal) {
            events.add("entity killed");
            events.add("entity killed by " + cause);
            events.add(entity.identifyType() + " killed");
            events.add(entity.identifyType() + " killed by " + cause);
            events.add(entity.identifySimple() + " killed");
            events.add(entity.identifySimple() + " killed by " + cause);
        }
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent subEvent = (EntityDamageByEntityEvent)event;
            dPlayer subPlayer = null;
            dNPC subNPC = null;
            dEntity projectile = null;
            dEntity damager = new dEntity(subEvent.getDamager());
            if (damager.isProjectile()) {
                projectile = damager;
                context.put("projectile", projectile);
                if (damager.hasShooter()) {
                    damager = damager.getShooter();
                }
                if (!damager.getEntityType().equals((Object)projectile.getEntityType())) {
                    events.add("entity damaged by projectile");
                    events.add("entity damaged by " + projectile.identifyType());
                    events.add(entity.identifyType() + " damaged by " + projectile.identifyType());
                    events.add(entity.identifySimple() + " damaged by " + projectile.identifyType());
                    events.add(entity.identifySimple() + " damaged by projectile");
                    events.add("entity damaged by " + projectile.identifyType());
                    events.add(entity.identifyType() + " damaged by " + projectile.identifyType());
                    events.add(entity.identifySimple() + " damaged by " + projectile.identifyType());
                }
            }
            context.put("damager", damager.getDenizenObject());
            events.add("entity damaged by entity");
            events.add("entity damaged by " + damager.identifyType());
            events.add("entity damaged by " + damager.identifySimple());
            events.add(entity.identifyType() + " damaged by entity");
            events.add(entity.identifyType() + " damaged by " + damager.identifyType());
            events.add(entity.identifyType() + " damaged by " + damager.identifySimple());
            events.add(entity.identifySimple() + " damaged by entity");
            events.add(entity.identifySimple() + " damaged by " + damager.identifyType());
            events.add(entity.identifySimple() + " damaged by " + damager.identifySimple());
            if (damager.isNPC()) {
                subNPC = damager.getDenizenNPC();
                if (npc == null) {
                    npc = subNPC;
                }
            } else if (damager.isPlayer()) {
                subPlayer = new dPlayer(damager.getPlayer());
                if (player == null) {
                    player = subPlayer;
                }
            }
            ArrayList<String> subEvents = new ArrayList<String>();
            subEvents.add("entity damages entity");
            subEvents.add("entity damages " + entity.identifyType());
            subEvents.add("entity damages " + entity.identifySimple());
            subEvents.add(damager.identifyType() + " damages entity");
            subEvents.add(damager.identifyType() + " damages " + entity.identifyType());
            subEvents.add(damager.identifyType() + " damages " + entity.identifySimple());
            subEvents.add(damager.identifySimple() + " damages entity");
            subEvents.add(damager.identifySimple() + " damages " + entity.identifyType());
            subEvents.add(damager.identifySimple() + " damages " + entity.identifySimple());
            if (projectile != null && !damager.getEntityType().equals((Object)projectile.getEntityType())) {
                subEvents.add("projectile damages entity");
                subEvents.add("projectile damages " + entity.identifyType());
                subEvents.add("projectile damages " + entity.identifySimple());
                subEvents.add(projectile.identifyType() + " damages entity");
                subEvents.add(projectile.identifyType() + " damages " + entity.identifyType());
                subEvents.add(projectile.identifyType() + " damages " + entity.identifySimple());
                subEvents.add(projectile.identifySimple() + " damages entity");
                subEvents.add(projectile.identifySimple() + " damages " + entity.identifyType());
                subEvents.add(projectile.identifySimple() + " damages " + entity.identifySimple());
            }
            if (isFatal) {
                events.add("entity killed by entity");
                events.add("entity killed by " + damager.identifyType());
                events.add("entity killed by " + damager.identifySimple());
                events.add(entity.identifyType() + " killed by entity");
                events.add(entity.identifyType() + " killed by " + damager.identifyType());
                events.add(entity.identifyType() + " killed by " + damager.identifySimple());
                events.add(entity.identifySimple() + " killed by entity");
                events.add(entity.identifySimple() + " killed by " + damager.identifyType());
                events.add(entity.identifySimple() + " killed by " + damager.identifySimple());
                if (projectile != null && !damager.getEntityType().equals((Object)projectile.getEntityType())) {
                    events.add("entity killed by projectile");
                    events.add("entity killed by " + projectile.identifyType());
                    events.add(entity.identifyType() + " killed by projectile");
                    events.add(entity.identifyType() + " killed by " + projectile.identifyType());
                    events.add(entity.identifyType() + " killed by " + projectile.identifySimple());
                    events.add(entity.identifySimple() + " killed by projectile");
                    events.add(entity.identifySimple() + " killed by " + projectile.identifyType());
                    events.add(entity.identifySimple() + " killed by " + projectile.identifySimple());
                }
                subEvents.add("entity kills entity");
                subEvents.add("entity kills " + entity.identifyType());
                subEvents.add("entity kills " + entity.identifySimple());
                subEvents.add(damager.identifyType() + " kills entity");
                subEvents.add(damager.identifyType() + " kills " + entity.identifyType());
                subEvents.add(damager.identifyType() + " kills " + entity.identifySimple());
                subEvents.add(damager.identifySimple() + " kills entity");
                subEvents.add(damager.identifySimple() + " kills " + entity.identifyType());
                subEvents.add(damager.identifySimple() + " kills " + entity.identifySimple());
                if (projectile != null && !damager.getEntityType().equals((Object)projectile.getEntityType())) {
                    subEvents.add("projectile kills entity");
                    subEvents.add(projectile.identifyType() + " kills entity");
                    subEvents.add(projectile.identifyType() + " kills " + entity.identifyType());
                    subEvents.add(projectile.identifyType() + " kills " + entity.identifySimple());
                    subEvents.add(projectile.identifySimple() + " kills entity");
                    subEvents.add(projectile.identifySimple() + " kills " + entity.identifyType());
                    subEvents.add(projectile.identifySimple() + " kills " + entity.identifySimple());
                }
            }
            if ((determination = BukkitWorldScriptHelper.doEvents(subEvents, subNPC, subPlayer, context, true)).toUpperCase().startsWith("CANCELLED")) {
                event.setCancelled(true);
            } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Double)) {
                event.setDamage(aH.getDoubleFrom(determination));
            }
        }
        if ((determination = BukkitWorldScriptHelper.doEvents(events, npc, player, context, true)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Double)) {
            event.setDamage(aH.getDoubleFrom(determination));
        }
    }
}

