/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityInteractSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        for (String event : events) {
            Matcher m = Pattern.compile("on (e@)?\\w+ interacts with (m@)?\\w+( in (cu@)?\\w+)?", 2).matcher(event);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Entity Interact SmartEvent.");
    }

    @Override
    public void breakDown() {
        EntityInteractEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void onEntityInteract(EntityInteractEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        ArrayList<String> events = new ArrayList<String>();
        dEntity entity = new dEntity(event.getEntity());
        dLocation location = new dLocation(event.getBlock().getLocation());
        dMaterial block = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        context.put("entity", entity);
        context.put("location", location);
        events.add("entity interacts with block");
        events.add("entity interacts with " + block.identifySimple());
        events.add(entity.identifySimple() + " interacts with " + block.identifySimple());
        events.add(entity.identifyType() + " interacts with " + block.identifySimple());
        List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(location);
        dList cuboid_context = new dList();
        ArrayList<String> cuboidevents = new ArrayList<String>();
        for (dCuboid cuboid : cuboids) {
            for (String evt : events) {
                cuboidevents.add(evt + " in " + cuboid.identifySimple());
            }
            cuboid_context.add(cuboid.identify());
        }
        context.put("cuboids", cuboid_context);
        events.addAll(cuboidevents);
        String Determination = BukkitWorldScriptHelper.doEvents(events, null, null, context, true);
        if (Determination.equalsIgnoreCase("CANCELLED")) {
            event.setCancelled(true);
        }
    }
}

