/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemMoveSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        for (String event : events) {
            Matcher m = Pattern.compile("on (i@)?\\w+ moves from (in@)?\\w+(to (in@)?\\w+)", 2).matcher(event);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Item Move SmartEvent.");
    }

    @Override
    public void breakDown() {
        InventoryMoveItemEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void inventoryMoveItemEvent(InventoryMoveItemEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getItem());
        String originType = event.getSource().getType().name();
        String destinationType = event.getDestination().getType().name();
        List<String> events = Arrays.asList("item moves from inventory", "item moves from " + originType, "item moves from " + originType + " to " + destinationType, item.identifySimple() + " moves from inventory", item.identifySimple() + " moves from " + originType, item.identifySimple() + " moves from " + originType + " to " + destinationType);
        context.put("origin", dInventory.mirrorBukkitInventory(event.getSource()));
        context.put("destination", dInventory.mirrorBukkitInventory(event.getDestination()));
        context.put("initiator", dInventory.mirrorBukkitInventory(event.getInitiator()));
        context.put("item", item);
        String determination = BukkitWorldScriptHelper.doEvents(events, null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (dItem.matches(determination)) {
            event.setItem(dItem.valueOf(determination).getItemStack());
        }
    }
}

