/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPingSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        for (String event : events) {
            Matcher m = Pattern.compile("on server list ping", 2).matcher(event);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded List Ping SmartEvent.");
    }

    @Override
    public void breakDown() {
        ServerListPingEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void onListPing(ServerListPingEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("motd", new Element(event.getMotd()));
        context.put("max_players", new Element(event.getMaxPlayers()));
        context.put("num_players", new Element(event.getNumPlayers()));
        context.put("address", new Element(event.getAddress().toString()));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("server list ping"), null, null, context);
        String[] values = determination.split("[\\|" + dList.internal_escape + "]", 2);
        if (new Element(values[0]).isInt()) {
            event.setMaxPlayers(new Element(values[0]).asInt());
        }
        if (determination.length() > 0 && !determination.equalsIgnoreCase("none")) {
            if (values.length == 2) {
                event.setMotd(values[1]);
            } else {
                event.setMotd(determination);
            }
        }
    }
}

