/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerStepsOnSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        for (String event : events) {
            Matcher m = Pattern.compile("on player steps on (m@)?\\w+( in (cu@)?\\w+)?", 2).matcher(event);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Player Steps On SmartEvent.");
    }

    @Override
    public void breakDown() {
        PlayerMoveEvent.getHandlerList().unregister((Listener)this);
        PlayerTeleportEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        PlayerMoveEvent evt = new PlayerMoveEvent(event.getPlayer(), event.getFrom(), event.getTo());
        this.onPlayerMove(evt);
        event.setCancelled(evt.isCancelled());
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlockX() != event.getTo().getBlockX() || event.getFrom().getBlockY() != event.getTo().getBlockY() || event.getFrom().getBlockZ() != event.getTo().getBlockZ()) {
            ArrayList<String> events = new ArrayList<String>();
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            dLocation block = new dLocation(event.getTo().clone().subtract(0.0, 1.0, 0.0));
            dMaterial mat = dMaterial.getMaterialFrom(block.getBlock().getType(), block.getBlock().getData());
            context.put("location", block);
            context.put("previous_location", new dLocation(event.getFrom()));
            context.put("new_location", new dLocation(event.getTo()));
            events.add("player steps on block");
            events.add("player steps on " + mat.identifySimple());
            List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(block);
            dList cuboid_context = new dList();
            for (dCuboid cuboid : cuboids) {
                events.add("player steps on block in " + cuboid.identifySimple());
                events.add("player steps on " + mat.identifySimple() + " in " + cuboid.identifySimple());
                cuboid_context.add(cuboid.identify());
            }
            context.put("cuboids", cuboid_context);
            String Determination = BukkitWorldScriptHelper.doEvents(events, null, new dPlayer(event.getPlayer()), context, true);
            if (Determination.equalsIgnoreCase("CANCELLED")) {
                event.setCancelled(true);
            }
        }
    }
}

