/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerWalkSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        for (String event : events) {
            Matcher m = Pattern.compile("on player walks", 2).matcher(event);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded PlayerWalk SmartEvent.");
    }

    @Override
    public void breakDown() {
        PlayerMoveEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("old_location", new dLocation(event.getFrom()));
        context.put("new_location", new dLocation(event.getTo()));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player walks"), null, new dPlayer(event.getPlayer()), context, true);
        if (determination.equalsIgnoreCase("CANCELLED")) {
            event.setCancelled(true);
        }
    }
}

