/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedstoneSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        for (String event : events) {
            Matcher m = Pattern.compile("on redstone recalculated", 2).matcher(event);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Redstone SmartEvent.");
    }

    @Override
    public void breakDown() {
        BlockRedstoneEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void onBlockRedstone(BlockRedstoneEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getBlock().getLocation()));
        context.put("old_current", new Element(event.getOldCurrent()));
        context.put("new_current", new Element(event.getNewCurrent()));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("redstone recalculated"), null, null, context, true);
        Element det = new Element(determination);
        if (det.isInt()) {
            event.setNewCurrent(det.asInt());
        }
    }
}

