/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.scripts.containers.core.FormatScriptContainer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncChatSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        if (Settings.worldScriptChatEventAsynchronous()) {
            return false;
        }
        for (String event : events) {
            Matcher m = Pattern.compile("on player chats", 2).matcher(event);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Sync Chat SmartEvent.");
    }

    @Override
    public void breakDown() {
        PlayerChatEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void playerChat(PlayerChatEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("message", new Element(event.getMessage()));
        context.put("format", new Element(event.getMessage()));
        dPlayer player = new dPlayer(event.getPlayer());
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player chats"), null, player, context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (determination.toUpperCase().startsWith("FORMAT:")) {
            String name = determination.substring(7);
            FormatScriptContainer format = (FormatScriptContainer)ScriptRegistry.getScriptContainer(name);
            if (format == null) {
                dB.echoError("Could not find format script matching '" + name + '\'');
            } else {
                event.setFormat(format.getFormattedText(event.getMessage(), null, player));
            }
        } else if (!determination.equals("none")) {
            event.setMessage(determination);
        }
    }
}

