/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VehicleCollisionSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        for (String event : events) {
            Matcher m = Pattern.compile("on (.+) collides with (.+)", 2).matcher(event);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Vehicle Collision SmartEvent.");
    }

    @Override
    public void breakDown() {
        VehicleBlockCollisionEvent.getHandlerList().unregister((Listener)this);
        VehicleEntityCollisionEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void vehicleBlockCollision(VehicleBlockCollisionEvent event) {
        if (event.getBlock().getType() == Material.AIR) {
            return;
        }
        dPlayer player = null;
        dNPC npc = null;
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        dMaterial material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("vehicle", vehicle);
        context.put("location", new dLocation(event.getBlock().getLocation()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("vehicle collides with block");
        events.add("vehicle collides with " + material.identifySimple());
        events.add(vehicle.identifyType() + " collides with block");
        events.add(vehicle.identifyType() + " collides with " + material.identifySimple());
        BukkitWorldScriptHelper.doEvents(events, npc, player, context, true);
    }

    @EventHandler
    public void vehicleEntityCollision(VehicleEntityCollisionEvent event) {
        dPlayer player = null;
        dNPC npc = null;
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        dEntity entity = new dEntity(event.getEntity());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("vehicle", vehicle);
        context.put("entity", entity.getDenizenObject());
        if (entity.isNPC()) {
            npc = entity.getDenizenNPC();
        } else if (entity.isPlayer()) {
            player = new dPlayer(entity.getPlayer());
        }
        ArrayList<String> events = new ArrayList<String>();
        events.add("vehicle collides with entity");
        events.add("vehicle collides with " + entity.identifyType());
        events.add(vehicle.identifyType() + " collides with entity");
        events.add(vehicle.identifyType() + " collides with " + entity.identifyType());
        String determination = BukkitWorldScriptHelper.doEvents(events, npc, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
        if (determination.toUpperCase().startsWith("NOPICKUP")) {
            event.setPickupCancelled(true);
        }
    }
}

