/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dObject;
import net.citizensnpcs.api.event.NPCTraitCommandAttachEvent;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;

public class MobproxTrait
extends Trait {
    int checkTimer = 0;
    int timerBounce = 0;
    LivingEntity liveEnt;
    dNPC dnpc;
    FlagManager.Flag frange;
    FlagManager.Flag facceptnpc;
    FlagManager.Flag ftimer;
    List<Entity> inrange = new ArrayList<Entity>();

    public MobproxTrait() {
        super("Mobprox");
    }

    public void run() {
        ++this.checkTimer;
        if (this.checkTimer == 10) {
            this.checkTimer = 0;
            ++this.timerBounce;
            if (this.timerBounce >= this.ftimer.getLast().asInteger()) {
                this.ftimer.rebuild();
                this.frange.rebuild();
                this.facceptnpc.rebuild();
                this.timerBounce = 0;
                if (this.getNPC().isSpawned()) {
                    int range = this.frange.getLast().asInteger();
                    boolean acceptnpc = this.facceptnpc.getLast().asBoolean();
                    List nearby = this.liveEnt.getNearbyEntities((double)range, (double)range, (double)range);
                    ArrayList<Entity> removeme = new ArrayList<Entity>();
                    removeme.addAll(this.inrange);
                    for (Entity ent : nearby) {
                        if (!(ent instanceof LivingEntity) || ent instanceof Player || !acceptnpc && new dEntity(ent).isNPC()) continue;
                        if (removeme.contains(ent)) {
                            removeme.remove(ent);
                        }
                        if (!this.inrange.contains(ent)) {
                            this.inrange.add(ent);
                            this.callAction("enter", ent);
                            continue;
                        }
                        this.callAction("move", ent);
                    }
                    for (Entity ent : removeme) {
                        this.inrange.remove(ent);
                        this.callAction("exit", ent);
                    }
                }
            }
        }
    }

    private void callAction(String act, Entity ent) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("entity", new dEntity(ent));
        this.dnpc.action("mob " + act + " proximity", null, context);
        this.dnpc.action(ent.getType().name() + " " + act + " proximity", null, context);
    }

    @EventHandler
    public void onTraitAttachEvent(NPCTraitCommandAttachEvent event) {
        if (!event.getTraitClass().equals(MobproxTrait.class)) {
            return;
        }
        if (event.getNPC() != this.getNPC()) {
            return;
        }
        this.onSpawn();
        AssignmentTrait at = this.dnpc.getAssignmentTrait();
        if (at == null || !at.hasAssignment()) {
            event.getCommandSender().sendMessage(ChatColor.RED + "Warning: This NPC doesn't have a script assigned! Mobprox only works with scripted Denizen NPCs!");
        }
    }

    public void onSpawn() {
        this.liveEnt = this.getNPC().getBukkitEntity();
        this.dnpc = dNPC.mirrorCitizensNPC(this.getNPC());
        this.frange = DenizenAPI.getCurrentInstance().flagManager().getNPCFlag(this.dnpc.getId(), "mobprox_range");
        if (this.frange.isEmpty()) {
            this.frange.set("10");
        }
        this.facceptnpc = DenizenAPI.getCurrentInstance().flagManager().getNPCFlag(this.dnpc.getId(), "mobprox_acceptnpcs");
        if (this.facceptnpc.isEmpty()) {
            this.facceptnpc.set("false");
        }
        this.ftimer = DenizenAPI.getCurrentInstance().flagManager().getNPCFlag(this.dnpc.getId(), "mobprox_timer");
        if (this.ftimer.isEmpty()) {
            this.ftimer.set("4");
        }
    }
}

