/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.entity.CraftFakeArrow;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.Plugin;

public class SittingTrait
extends Trait
implements Listener {
    @Persist(value="sitting")
    private boolean sitting = false;
    @Persist(value="chair location")
    private Location chairLocation = null;

    public void run() {
        if (!this.npc.isSpawned() || this.chairLocation == null) {
            return;
        }
        if (!Utilities.checkLocation(this.npc.getBukkitEntity(), this.chairLocation, 1.0)) {
            this.stand();
        }
    }

    public void onSpawn() {
        if (this.sitting) {
            this.sit();
        }
    }

    public void onDespawn() {
        if (this.npc.getEntity().getVehicle() != null) {
            this.npc.getEntity().getVehicle().setPassenger(null);
        }
    }

    public void sit() {
        DenizenAPI.getDenizenNPC(this.npc).action("sit", null);
        if (this.npc.getBukkitEntity().getType() != EntityType.PLAYER) {
            return;
        }
        this.sitInternal();
        this.chairLocation = this.npc.getBukkitEntity().getLocation().clone();
    }

    private void sitInternal() {
        CraftFakeArrow.createArrow(this.npc.getEntity().getLocation()).setPassenger(this.npc.getEntity());
        this.sitting = true;
    }

    private void standInternal() {
        Entity vehicle = this.npc.getEntity().getVehicle();
        this.npc.despawn();
        this.npc.spawn(this.npc.getStoredLocation().clone().add(0.0, 0.5, 0.0));
        if (vehicle != null && vehicle.isValid()) {
            vehicle.setPassenger(null);
            vehicle.remove();
        }
        this.sitting = false;
    }

    public void sit(Location location) {
        DenizenAPI.getDenizenNPC(this.npc).action("sit", null);
        if (this.npc.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        this.npc.teleport(location.clone().add(0.0, 0.5, 0.0), PlayerTeleportEvent.TeleportCause.PLUGIN);
        this.sitInternal();
        this.chairLocation = location;
    }

    public void stand() {
        DenizenAPI.getDenizenNPC(this.npc).action("stand", null);
        this.standInternal();
        this.standInternal();
        this.chairLocation = null;
    }

    public boolean isSitting() {
        return true;
    }

    public Location getChair() {
        return this.chairLocation;
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.chairLocation == null) {
            return;
        }
        if (event.getBlock().getLocation().equals((Object)this.chairLocation)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void arrowDismount(final VehicleExitEvent event) {
        if (event.getVehicle() instanceof CraftFakeArrow) {
            Bukkit.getScheduler().runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                public void run() {
                    if (event.getVehicle().isValid()) {
                        event.getVehicle().remove();
                    }
                }
            }, 1L);
        }
    }

    public SittingTrait() {
        super("sitting");
    }
}

