/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.notable.Notable;
import net.aufdemrand.denizencore.objects.notable.Note;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dEllipsoid
implements dObject,
Notable {
    private dLocation loc;
    private dLocation size;
    String prefix = "ellipsoid";

    public static dEllipsoid valueOf(String string) {
        return dEllipsoid.valueOf(string, null);
    }

    @Fetchable(value="ellipsoid")
    public static dEllipsoid valueOf(String string, TagContext context) {
        if (string.startsWith("ellipsoid@")) {
            string = string.substring(10);
        }
        if (NotableManager.isType(string, dEllipsoid.class)) {
            return (dEllipsoid)NotableManager.getSavedObject(string);
        }
        List<String> split = CoreUtilities.split(string, ',');
        if (split.size() != 7) {
            return null;
        }
        dLocation location = new dLocation(dWorld.valueOf(split.get(3)).getWorld(), aH.getDoubleFrom(split.get(0)), aH.getDoubleFrom(split.get(1)), aH.getDoubleFrom(split.get(2)));
        dLocation size = new dLocation(null, aH.getDoubleFrom(split.get(4)), aH.getDoubleFrom(split.get(5)), aH.getDoubleFrom(split.get(6)));
        return new dEllipsoid(location, size);
    }

    public static boolean matches(String arg) {
        return arg.startsWith("ellipsoid@");
    }

    public dEllipsoid(dLocation loc, dLocation size) {
        this.loc = loc;
        this.size = size;
    }

    public dList getBlocks() {
        return this.getBlocks(null);
    }

    public dList getBlocks(List<dMaterial> materials) {
        List<dLocation> initial = new dCuboid(new Location(this.loc.getWorld(), this.loc.getX() - this.size.getX(), this.loc.getY() - this.size.getY(), this.loc.getZ() - this.size.getZ()), new Location(this.loc.getWorld(), this.loc.getX() + this.size.getX(), this.loc.getY() + this.size.getY(), this.loc.getZ() + this.size.getZ())).getBlocks_internal(materials);
        dList list = new dList();
        for (dLocation loc : initial) {
            if (!this.contains(loc)) continue;
            list.add(loc.identify());
        }
        return list;
    }

    public List<dLocation> getBlockLocations() {
        List<dLocation> initial = new dCuboid(new Location(this.loc.getWorld(), this.loc.getX() - this.size.getX(), this.loc.getY() - this.size.getY(), this.loc.getZ() - this.size.getZ()), new Location(this.loc.getWorld(), this.loc.getX() + this.size.getX(), this.loc.getY() + this.size.getY(), this.loc.getZ() + this.size.getZ())).getBlocks_internal(null);
        ArrayList<dLocation> locations = new ArrayList<dLocation>();
        for (dLocation loc : initial) {
            if (!this.contains(loc)) continue;
            locations.add(loc);
        }
        return locations;
    }

    public boolean contains(dLocation test) {
        double xbase = test.getX() - this.loc.getX();
        double ybase = test.getY() - this.loc.getY();
        double zbase = test.getZ() - this.loc.getZ();
        return xbase * xbase / (this.size.getX() * this.size.getX()) + ybase * ybase / (this.size.getY() * this.size.getY()) + zbase * zbase / (this.size.getZ() * this.size.getZ()) < 1.0;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    @Note(value="Ellipsoids")
    public Object getSaveObject() {
        return this.identifyFull().substring(10);
    }

    @Override
    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    @Override
    public void forget() {
        NotableManager.remove(this);
    }

    @Override
    public String getObjectType() {
        return "Ellipsoid";
    }

    @Override
    public String identify() {
        if (this.isUnique()) {
            return "ellipsoid@" + NotableManager.getSavedId(this);
        }
        return this.identifyFull();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String identifyFull() {
        return "ellipsoid@" + this.loc.getX() + "," + this.loc.getY() + "," + this.loc.getZ() + "," + this.loc.getWorld().getName() + "," + this.size.getX() + "," + this.size.getY() + "," + this.size.getZ();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public dObject setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute.startsWith("get_blocks")) {
            if (attribute.hasContext(1)) {
                return new dList(this.getBlocks(dList.valueOf(attribute.getContext(1)).filter(dMaterial.class))).getAttribute(attribute.fulfill(1));
            }
            return new dList(this.getBlocks()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location")) {
            return this.loc.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("size")) {
            return this.size.getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }
}

