/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.objects.dChunk;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEllipsoid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.PathFinder;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Rotation;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.notable.Notable;
import net.aufdemrand.denizencore.objects.notable.Note;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.tags.core.EscapeTags;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.util.Vector;

public class dLocation
extends Location
implements dObject,
Notable,
Adjustable {
    static final Pattern notablePattern = Pattern.compile("(\\w+)[;,]((-?\\d+\\.?\\d*,){3,5}.+)", 2);
    static final Pattern item_by_saved = Pattern.compile("(l@)(.+)");
    static final Pattern location_by_saved = Pattern.compile("(l@)(.+)");
    private boolean is2D = false;
    private boolean raw = false;
    String prefix = "Location";

    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    @Note(value="Locations")
    public String getSaveObject() {
        return (double)this.getBlockX() + 0.5 + "," + this.getBlockY() + "," + ((double)this.getBlockZ() + 0.5) + "," + this.getPitch() + "," + this.getYaw() + "," + this.getWorld().getName();
    }

    public static String getSaved(dLocation location) {
        for (dLocation saved : NotableManager.getAllType(dLocation.class)) {
            if (saved.getBlockX() != location.getBlockX() || saved.getBlockY() != location.getBlockY() || saved.getBlockZ() != location.getBlockZ() || !saved.getWorld().getName().equals(location.getWorld().getName())) continue;
            return NotableManager.getSavedId(saved);
        }
        return null;
    }

    public void forget() {
        NotableManager.remove(this);
    }

    public static void _recallLocations() {
        List loclist = DenizenAPI.getCurrentInstance().getSaves().getStringList("dScript.Locations");
        for (String location : loclist) {
            Matcher m = notablePattern.matcher(location);
            if (!m.matches()) continue;
            String id = m.group(1);
            dLocation loc = dLocation.valueOf(m.group(2));
            NotableManager.saveAs(loc, id);
        }
        DenizenAPI.getCurrentInstance().getSaves().set("dScript.Locations", null);
    }

    public static dLocation valueOf(String string) {
        return dLocation.valueOf(string, null);
    }

    @Fetchable(value="l")
    public static dLocation valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        Matcher m = item_by_saved.matcher(string);
        if (m.matches() && NotableManager.isSaved(m.group(2)) && NotableManager.isType(m.group(2), dLocation.class)) {
            return (dLocation)NotableManager.getSavedObject(m.group(2));
        }
        String[] split = StringUtils.split((String)(string.startsWith("l@") ? string.substring(2) : string), (char)',');
        if (split.length == 2) {
            try {
                return new dLocation(null, Double.valueOf(split[0]), Double.valueOf(split[1]));
            }
            catch (Exception e) {
                dB.echoError("valueOf dLocation returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                return null;
            }
        }
        if (split.length == 3) {
            try {
                World world = Bukkit.getWorld((String)split[2]);
                if (world != null) {
                    return new dLocation(world, Double.valueOf(split[0]), Double.valueOf(split[1]));
                }
                return new dLocation(null, Double.valueOf(split[0]), Double.valueOf(split[1]), Double.valueOf(split[2]));
            }
            catch (Exception e) {
                dB.echoError("valueOf dLocation returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                return null;
            }
        }
        if (split.length == 4) {
            try {
                return new dLocation(Bukkit.getWorld((String)split[3]), Double.valueOf(split[0]), Double.valueOf(split[1]), Double.valueOf(split[2]));
            }
            catch (Exception e) {
                dB.echoError("valueOf dLocation returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                return null;
            }
        }
        if (split.length == 6) {
            try {
                return new dLocation(Bukkit.getWorld((String)split[5]), Double.valueOf(split[0]), Double.valueOf(split[1]), Double.valueOf(split[2]), Float.valueOf(split[3]).floatValue(), Float.valueOf(split[4]).floatValue());
            }
            catch (Exception e) {
                dB.echoError("valueOf dLocation returning null: " + string + "(internal exception:" + e.getMessage() + ")");
                return null;
            }
        }
        dB.log("valueOf dLocation returning null: " + string);
        return null;
    }

    public static boolean matches(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        Matcher m = location_by_saved.matcher(string);
        if (m.matches()) {
            return true;
        }
        String[] data = string.split(",");
        return data.length >= 2 && new Element(data[0]).isDouble() && new Element(data[1]).isDouble();
    }

    public dLocation(Location location) {
        super(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public dLocation(World world, double x, double y) {
        this(world, x, y, 0.0);
        this.is2D = true;
    }

    public dLocation(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public dLocation(World world, double x, double y, double z, float yaw, float pitch) {
        super(world, x, y, z, pitch, yaw);
    }

    private void setRaw(boolean state) {
        this.raw = state;
    }

    public void setPitch(float pitch) {
        super.setPitch(pitch);
    }

    public void setYaw(float yaw) {
        super.setYaw(yaw);
    }

    public boolean hasInventory() {
        return this.getBlock().getState() instanceof InventoryHolder;
    }

    public Inventory getBukkitInventory() {
        return this.hasInventory() ? ((InventoryHolder)this.getBlock().getState()).getInventory() : null;
    }

    public dInventory getInventory() {
        return this.hasInventory() ? new dInventory(this.getBukkitInventory()) : null;
    }

    public int compare(Location loc1, Location loc2) {
        if (loc1 == null || loc2 == null || loc1.equals((Object)loc2)) {
            return 0;
        }
        double dist = this.distanceSquared(loc1) - this.distanceSquared(loc2);
        return dist == 0.0 ? 0 : (dist > 0.0 ? 1 : -1);
    }

    public int hashCode() {
        return (int)(Math.floor(this.getX()) + Math.floor(this.getY()) + Math.floor(this.getZ()));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof dLocation)) {
            return false;
        }
        dLocation other = (dLocation)o;
        if (other.getWorld() == null && this.getWorld() != null || this.getWorld() == null && other.getWorld() != null || this.getWorld() != null && other.getWorld() != null && !this.getWorld().getName().equalsIgnoreCase(other.getWorld().getName())) {
            return false;
        }
        return Math.floor(this.getX()) == Math.floor(other.getX()) && Math.floor(this.getY()) == Math.floor(other.getY()) && Math.floor(this.getZ()) == Math.floor(other.getZ());
    }

    public String getObjectType() {
        return "Location";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public dLocation setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return this.isUnique() ? "<G>" + this.prefix + "='<A>" + this.identify() + "(<Y>" + this.identifyRaw() + "<A>)<G>'  " : "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    public boolean isUnique() {
        return dLocation.getSaved(this) != null;
    }

    public String identify() {
        if (!this.raw && this.isUnique()) {
            return "l@" + dLocation.getSaved(this);
        }
        return this.identifyRaw();
    }

    public String identifySimple() {
        if (this.isUnique()) {
            return "l@" + dLocation.getSaved(this);
        }
        if (this.getWorld() == null) {
            return "l@" + this.getBlockX() + "," + this.getBlockY() + (!this.is2D ? "," + this.getBlockZ() : "");
        }
        return "l@" + this.getBlockX() + "," + this.getBlockY() + (!this.is2D ? "," + this.getBlockZ() : "") + "," + this.getWorld().getName();
    }

    public String identifyRaw() {
        if ((double)this.getYaw() != 0.0 || (double)this.getPitch() != 0.0) {
            return "l@" + this.getX() + "," + this.getY() + "," + this.getZ() + "," + this.getPitch() + "," + this.getYaw() + (this.getWorld() != null ? "," + this.getWorld().getName() : "");
        }
        return "l@" + this.getX() + "," + this.getY() + (!this.is2D ? "," + this.getZ() : "") + (this.getWorld() != null ? "," + this.getWorld().getName() : "");
    }

    public String toString() {
        return this.identify();
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("above")) {
            return new dLocation(this.add(0.0, 1.0, 0.0)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("below")) {
            return new dLocation(this.add(0.0, -1.0, 0.0)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("block")) {
            return new dLocation(this.getWorld(), this.getBlockX(), this.getBlockY(), this.getBlockZ()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("highest")) {
            return new dLocation(this.getWorld().getHighestBlockAt((Location)this).getLocation().add(0.0, -1.0, 0.0)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_inventory")) {
            return new Element(this.getBlock().getState() instanceof InventoryHolder).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("inventory")) {
            return Element.handleNull(this.identify() + ".inventory", this.getInventory(), "dInventory", attribute.hasAlternative()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("material")) {
            return dMaterial.getMaterialFrom(this.getBlock().getType(), this.getBlock().getData()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("switched")) {
            return new Element((this.getBlock().getData() & 8) > 0).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("sign_contents")) {
            if (this.getBlock().getState() instanceof Sign) {
                return new dList(Arrays.asList(((Sign)this.getBlock().getState()).getLines())).getAttribute(attribute.fulfill(1));
            }
            return "null";
        }
        if (attribute.startsWith("spawner_type")) {
            if (this.getBlock().getState() instanceof CreatureSpawner) {
                return new dEntity(((CreatureSpawner)this.getBlock().getState()).getSpawnedType()).getAttribute(attribute.fulfill(1));
            }
            return "null";
        }
        if (attribute.startsWith("skull_skin")) {
            if (this.getBlock().getState() instanceof Skull) {
                return new Element(((Skull)this.getBlock().getState()).getOwner()).getAttribute(attribute.fulfill(1));
            }
            return "null";
        }
        if (attribute.startsWith("simple.formatted")) {
            return new Element("X '" + this.getBlockX() + "', Y '" + this.getBlockY() + "', Z '" + this.getBlockZ() + "', in world '" + this.getWorld().getName() + "'").getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("simple")) {
            if (this.getWorld() == null) {
                return new Element(this.getBlockX() + "," + this.getBlockY() + "," + this.getBlockZ()).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.getBlockX() + "," + this.getBlockY() + "," + this.getBlockZ() + "," + this.getWorld().getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("precise_cursor_on")) {
            double xzLen = Math.cos((double)(this.getPitch() % 360.0f) * (Math.PI / 180));
            double nx = xzLen * Math.sin((double)(-this.getYaw()) * (Math.PI / 180));
            double ny = Math.sin((double)this.getPitch() * (Math.PI / 180));
            double nz = xzLen * Math.cos((double)this.getYaw() * (Math.PI / 180));
            return new dLocation(Rotation.rayTrace(this, new Vector(nx, -ny, nz), 200.0)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("direction.vector")) {
            double xzLen = Math.cos((double)(this.getPitch() % 360.0f) * (Math.PI / 180));
            double nx = xzLen * Math.sin((double)(-this.getYaw()) * (Math.PI / 180));
            double ny = Math.sin((double)this.getPitch() * (Math.PI / 180));
            double nz = xzLen * Math.cos((double)this.getYaw() * (Math.PI / 180));
            return new dLocation(this.getWorld(), nx, -ny, nz).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("direction")) {
            if (attribute.hasContext(1) && dLocation.matches(attribute.getContext(1))) {
                dLocation target = dLocation.valueOf(attribute.getContext(1));
                if ((attribute = attribute.fulfill(1)).startsWith("yaw")) {
                    return new Element(Float.valueOf(Rotation.normalizeYaw(Rotation.getYaw(target.toVector().subtract(this.toVector()).normalize())))).getAttribute(attribute.fulfill(1));
                }
                return new Element(Rotation.getCardinal(Rotation.getYaw(target.toVector().subtract(this.toVector()).normalize()))).getAttribute(attribute);
            }
            return new Element(Rotation.getCardinal(this.getYaw())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("facing") && attribute.hasContext(1)) {
            int degrees = 45;
            int attributePos = 1;
            if (attribute.getAttribute(2).startsWith("degrees") && attribute.hasContext(2) && aH.matchesInteger(attribute.getContext(2))) {
                degrees = attribute.getIntContext(2);
                ++attributePos;
            }
            if (dLocation.matches(attribute.getContext(1))) {
                return new Element(Rotation.isFacingLocation(this, (Location)dLocation.valueOf(attribute.getContext(1)), (float)degrees)).getAttribute(attribute.fulfill(attributePos));
            }
            if (dEntity.matches(attribute.getContext(1))) {
                return new Element(Rotation.isFacingLocation(this, dEntity.valueOf(attribute.getContext(1)).getBukkitEntity().getLocation(), (float)degrees)).getAttribute(attribute.fulfill(attributePos));
            }
        }
        if (attribute.startsWith("pitch")) {
            return new Element(Float.valueOf(this.getPitch())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("with_pose")) {
            String context = attribute.getContext(1);
            Float pitch = Float.valueOf(0.0f);
            Float yaw = Float.valueOf(0.0f);
            if (dEntity.matches(context)) {
                dEntity ent = dEntity.valueOf(context);
                if (ent.isSpawned()) {
                    pitch = Float.valueOf(ent.getBukkitEntity().getLocation().getPitch());
                    yaw = Float.valueOf(ent.getBukkitEntity().getLocation().getYaw());
                }
            } else if (context.split(",").length == 2) {
                String[] split = context.split(",");
                pitch = Float.valueOf(split[0]);
                yaw = Float.valueOf(split[1]);
            }
            dLocation loc = dLocation.valueOf(this.identify());
            loc.setPitch(pitch.floatValue());
            loc.setYaw(yaw.floatValue());
            return loc.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("yaw.simple")) {
            float yaw = Rotation.normalizeYaw(this.getYaw());
            if (yaw < 45.0f) {
                return new Element("South").getAttribute(attribute.fulfill(2));
            }
            if (yaw < 135.0f) {
                return new Element("West").getAttribute(attribute.fulfill(2));
            }
            if (yaw < 225.0f) {
                return new Element("North").getAttribute(attribute.fulfill(2));
            }
            if (yaw < 315.0f) {
                return new Element("East").getAttribute(attribute.fulfill(2));
            }
            return new Element("South").getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("yaw.raw")) {
            return new Element(Float.valueOf(this.getYaw())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("yaw")) {
            return new Element(Float.valueOf(Rotation.normalizeYaw(this.getYaw()))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.matches("find") || attribute.startsWith("nearest")) {
            attribute.fulfill(1);
            if (attribute.startsWith("blocks") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                ArrayList<dLocation> found = new ArrayList<dLocation>();
                double radius = aH.matchesDouble(attribute.getContext(2)) ? attribute.getDoubleContext(2) : 10.0;
                List<Object> materials = new ArrayList();
                if (attribute.hasContext(1)) {
                    materials = dList.valueOf(attribute.getContext(1)).filter(dMaterial.class);
                }
                if (materials == null) {
                    return null;
                }
                int max = Settings.blockTagsMaxBlocks();
                int index = 0;
                attribute.fulfill(2);
                Location loc = this.getBlock().getLocation().add(0.5, 0.5, 0.5);
                block0: for (double x = -radius; x <= radius; x += 1.0) {
                    for (double y = -radius; y <= radius; y += 1.0) {
                        for (double z = -radius; z <= radius; z += 1.0) {
                            if (++index > max) break block0;
                            if (!Utilities.checkLocation(loc, this.getBlock().getLocation().add(x, y, z), radius)) continue;
                            if (!materials.isEmpty()) {
                                for (dMaterial dMaterial2 : materials) {
                                    if (dMaterial2.hasData() && dMaterial2.getData() != 0) {
                                        if (!dMaterial2.matchesMaterialData(this.getBlock().getLocation().add(x, y, z).getBlock().getType().getNewData(this.getBlock().getLocation().add(x, y, z).getBlock().getData()))) continue;
                                        found.add(new dLocation(this.getBlock().getLocation().add(x + 0.5, y, z + 0.5)));
                                        continue;
                                    }
                                    if (dMaterial2.getMaterial() != this.getBlock().getLocation().add(x, y, z).getBlock().getType()) continue;
                                    found.add(new dLocation(this.getBlock().getLocation().add(x + 0.5, y, z + 0.5)));
                                }
                                continue;
                            }
                            found.add(new dLocation(this.getBlock().getLocation().add(x + 0.5, y, z + 0.5)));
                        }
                    }
                }
                Collections.sort(found, new Comparator<dLocation>(){

                    @Override
                    public int compare(dLocation loc1, dLocation loc2) {
                        return dLocation.this.compare(loc1, loc2);
                    }
                });
                return new dList((Collection<? extends dObject>)found).getAttribute(attribute);
            }
            if (attribute.startsWith("surface_blocks") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                ArrayList<dLocation> found = new ArrayList<dLocation>();
                double radius = aH.matchesDouble(attribute.getContext(2)) ? attribute.getDoubleContext(2) : 10.0;
                List<Object> materials = new ArrayList();
                if (attribute.hasContext(1)) {
                    materials = dList.valueOf(attribute.getContext(1)).filter(dMaterial.class);
                }
                if (materials == null) {
                    return null;
                }
                int max = Settings.blockTagsMaxBlocks();
                int index = 0;
                attribute.fulfill(2);
                Location loc = this.getBlock().getLocation().add(0.5, 0.5, 0.5);
                block4: for (double x = -radius; x <= radius; x += 1.0) {
                    for (double y = -radius; y <= radius; y += 1.0) {
                        for (double z = -radius; z <= radius; z += 1.0) {
                            if (++index > max) break block4;
                            if (!Utilities.checkLocation(loc, this.getBlock().getLocation().add(x, y, z), radius)) continue;
                            Location l = this.getBlock().getLocation().clone().add(x, y, z);
                            if (!materials.isEmpty()) {
                                for (dMaterial dMaterial3 : materials) {
                                    if (!dMaterial3.matchesMaterialData(this.getBlock().getLocation().clone().add(x, y, z).getBlock().getType().getNewData(this.getBlock().getLocation().clone().add(x, y, z).getBlock().getData())) || l.clone().add(0.0, 1.0, 0.0).getBlock().getType() != Material.AIR || l.clone().add(0.0, 2.0, 0.0).getBlock().getType() != Material.AIR || l.getBlock().getType() == Material.AIR) continue;
                                    found.add(new dLocation(this.getBlock().getLocation().clone().add(x + 0.5, y, z + 0.5)));
                                }
                                continue;
                            }
                            if (l.clone().add(0.0, 1.0, 0.0).getBlock().getType() != Material.AIR || l.clone().add(0.0, 2.0, 0.0).getBlock().getType() != Material.AIR || l.getBlock().getType() == Material.AIR) continue;
                            found.add(new dLocation(this.getBlock().getLocation().clone().add(x + 0.5, y, z + 0.5)));
                        }
                    }
                }
                Collections.sort(found, new Comparator<dLocation>(){

                    @Override
                    public int compare(dLocation loc1, dLocation loc2) {
                        return dLocation.this.compare(loc1, loc2);
                    }
                });
                return new dList((Collection<? extends dObject>)found).getAttribute(attribute);
            }
            if (attribute.startsWith("players") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                ArrayList<dPlayer> found = new ArrayList<dPlayer>();
                double radius = aH.matchesDouble(attribute.getContext(2)) ? attribute.getDoubleContext(2) : 10.0;
                attribute.fulfill(2);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (player.isDead() || !Utilities.checkLocation(this, player.getLocation(), radius)) continue;
                    found.add(new dPlayer(player));
                }
                Collections.sort(found, new Comparator<dPlayer>(){

                    @Override
                    public int compare(dPlayer pl1, dPlayer pl2) {
                        return dLocation.this.compare(pl1.getLocation(), pl2.getLocation());
                    }
                });
                return new dList((Collection<? extends dObject>)found).getAttribute(attribute);
            }
            if (attribute.startsWith("npcs") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                ArrayList<dNPC> found = new ArrayList<dNPC>();
                double radius = aH.matchesDouble(attribute.getContext(2)) ? attribute.getDoubleContext(2) : 10.0;
                attribute.fulfill(2);
                for (dNPC npc : DenizenAPI.getSpawnedNPCs()) {
                    if (!Utilities.checkLocation(this.getBlock().getLocation(), (Location)npc.getLocation(), radius)) continue;
                    found.add(npc);
                }
                Collections.sort(found, new Comparator<dNPC>(){

                    @Override
                    public int compare(dNPC npc1, dNPC npc2) {
                        return dLocation.this.compare(npc1.getLocation(), npc2.getLocation());
                    }
                });
                return new dList((Collection<? extends dObject>)found).getAttribute(attribute);
            }
            if (attribute.startsWith("entities") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                dList ent_list = new dList();
                if (attribute.hasContext(1)) {
                    for (String ent : dList.valueOf(attribute.getContext(1))) {
                        if (!dEntity.matches(ent)) continue;
                        ent_list.add(ent.toUpperCase());
                    }
                }
                ArrayList<dEntity> found = new ArrayList<dEntity>();
                double radius = aH.matchesDouble(attribute.getContext(2)) ? attribute.getDoubleContext(2) : 10.0;
                attribute.fulfill(2);
                block11: for (Entity entity : this.getWorld().getEntities()) {
                    if (!Utilities.checkLocation(this, entity.getLocation(), radius)) continue;
                    dEntity current = new dEntity(entity);
                    if (!ent_list.isEmpty()) {
                        for (String ent : ent_list) {
                            if (!entity.getType().name().equals(ent) && !current.identify().equalsIgnoreCase(ent) || !entity.isValid()) continue;
                            found.add(current);
                            continue block11;
                        }
                        continue;
                    }
                    found.add(current);
                }
                Collections.sort(found, new Comparator<dEntity>(){

                    @Override
                    public int compare(dEntity ent1, dEntity ent2) {
                        return dLocation.this.compare(ent1.getLocation(), ent2.getLocation());
                    }
                });
                return new dList((Collection<? extends dObject>)found).getAttribute(attribute);
            }
            if (attribute.startsWith("living_entities") && attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2)) {
                ArrayList<dEntity> found = new ArrayList<dEntity>();
                double radius = aH.matchesDouble(attribute.getContext(2)) ? attribute.getDoubleContext(2) : 10.0;
                attribute.fulfill(2);
                for (Entity entity : this.getWorld().getEntities()) {
                    if (!(entity instanceof LivingEntity) || !Utilities.checkLocation(this, entity.getLocation(), radius)) continue;
                    found.add(new dEntity(entity));
                }
                Collections.sort(found, new Comparator<dEntity>(){

                    @Override
                    public int compare(dEntity ent1, dEntity ent2) {
                        return dLocation.this.compare(ent1.getLocation(), ent2.getLocation());
                    }
                });
                return new dList((Collection<? extends dObject>)found).getAttribute(attribute);
            }
        }
        if (attribute.startsWith("find_path") && attribute.hasContext(1)) {
            PathFinder.Node node;
            dLocation two = dLocation.valueOf(attribute.getContext(1));
            if (two == null) {
                return null;
            }
            attribute = attribute.fulfill(1);
            int radius = 2;
            if (attribute.startsWith("radius") && attribute.hasContext(1)) {
                radius = new Element(attribute.getContext(1)).asInt();
                attribute = attribute.fulfill(1);
            }
            if ((node = PathFinder.findPath(this, two, radius)) == null) {
                return null;
            }
            dList list = new dList();
            while (node != null) {
                list.add(node.position.identify());
                node = node.next;
            }
            return list.getAttribute(attribute);
        }
        if (attribute.startsWith("formatted.citizens")) {
            return new Element(this.getX() + ":" + this.getY() + ":" + this.getZ() + ":" + this.getWorld().getName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("formatted")) {
            return new Element("X '" + this.getX() + "', Y '" + this.getY() + "', Z '" + this.getZ() + "', in world '" + this.getWorld().getName() + "'").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("get_chunk") || attribute.startsWith("chunk")) {
            return new dChunk(this).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("raw")) {
            dLocation rawLocation = new dLocation(this);
            rawLocation.setRaw(true);
            return rawLocation.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("world")) {
            return dWorld.mirrorBukkitWorld(this.getWorld()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("x")) {
            return new Element(this.getX()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("y")) {
            return new Element(this.getY()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("z")) {
            return new Element(this.getZ()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("notable_name")) {
            return new Element(NotableManager.getSavedId(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("add") && attribute.hasContext(1)) {
            String[] ints = attribute.getContext(1).replace("l@", "").split(",", 4);
            if (ints.length >= 3) {
                if ((aH.matchesDouble(ints[0]) || aH.matchesInteger(ints[0])) && (aH.matchesDouble(ints[1]) || aH.matchesInteger(ints[1])) && (aH.matchesDouble(ints[2]) || aH.matchesInteger(ints[2]))) {
                    return new dLocation(this.clone().add(Double.valueOf(ints[0]).doubleValue(), Double.valueOf(ints[1]).doubleValue(), Double.valueOf(ints[2]).doubleValue())).getAttribute(attribute.fulfill(1));
                }
            } else if (dLocation.matches(attribute.getContext(1))) {
                return new dLocation(this.clone().add((Location)dLocation.valueOf(attribute.getContext(1)))).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("sub") && attribute.hasContext(1)) {
            String[] ints = attribute.getContext(1).replace("l@", "").split(",", 4);
            if (ints.length == 3 || ints.length == 4) {
                if ((aH.matchesDouble(ints[0]) || aH.matchesInteger(ints[0])) && (aH.matchesDouble(ints[1]) || aH.matchesInteger(ints[1])) && (aH.matchesDouble(ints[2]) || aH.matchesInteger(ints[2]))) {
                    return new dLocation(this.clone().subtract(Double.valueOf(ints[0]).doubleValue(), Double.valueOf(ints[1]).doubleValue(), Double.valueOf(ints[2]).doubleValue())).getAttribute(attribute.fulfill(1));
                }
            } else if (dLocation.matches(attribute.getContext(1))) {
                return new dLocation(this.clone().subtract((Location)dLocation.valueOf(attribute.getContext(1)))).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("mul") && attribute.hasContext(1)) {
            return new dLocation(this.clone().multiply(Double.parseDouble(attribute.getContext(1)))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("div") && attribute.hasContext(1)) {
            return new dLocation(this.clone().multiply(1.0 / Double.parseDouble(attribute.getContext(1)))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("normalize")) {
            double len = Math.sqrt(Math.pow(this.getX(), 2.0) + Math.pow(this.getY(), 2.0) + Math.pow(this.getZ(), 2.0));
            if (len == 0.0) {
                return this.getAttribute(attribute.fulfill(1));
            }
            return new dLocation(this.clone().multiply(1.0 / len)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("vector_length")) {
            return new Element(Math.sqrt(Math.pow(this.getX(), 2.0) + Math.pow(this.getY(), 2.0) + Math.pow(this.getZ(), 2.0))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("distance_squared") && attribute.hasContext(1) && dLocation.matches(attribute.getContext(1))) {
            dLocation toLocation = dLocation.valueOf(attribute.getContext(1));
            if (!this.getWorld().getName().equalsIgnoreCase(toLocation.getWorld().getName())) {
                if (!attribute.hasAlternative()) {
                    dB.echoError("Can't measure distance between two different worlds!");
                }
                return null;
            }
            return new Element(this.distanceSquared(toLocation)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("distance") && attribute.hasContext(1) && dLocation.matches(attribute.getContext(1))) {
            dLocation toLocation = dLocation.valueOf(attribute.getContext(1));
            if (attribute.getAttribute(2).startsWith("horizontal")) {
                if (attribute.getAttribute(3).startsWith("multiworld")) {
                    return new Element(Math.sqrt(Math.pow(this.getX() - toLocation.getX(), 2.0) + Math.pow(this.getZ() - toLocation.getZ(), 2.0))).getAttribute(attribute.fulfill(3));
                }
                if (this.getWorld() == toLocation.getWorld()) {
                    return new Element(Math.sqrt(Math.pow(this.getX() - toLocation.getX(), 2.0) + Math.pow(this.getZ() - toLocation.getZ(), 2.0))).getAttribute(attribute.fulfill(2));
                }
            } else if (attribute.getAttribute(2).startsWith("vertical")) {
                if (attribute.getAttribute(3).startsWith("multiworld")) {
                    return new Element(Math.abs(this.getY() - toLocation.getY())).getAttribute(attribute.fulfill(3));
                }
                if (this.getWorld() == toLocation.getWorld()) {
                    return new Element(Math.abs(this.getY() - toLocation.getY())).getAttribute(attribute.fulfill(2));
                }
            }
            if (!this.getWorld().getName().equalsIgnoreCase(toLocation.getWorld().getName())) {
                if (!attribute.hasAlternative()) {
                    dB.echoError("Can't measure distance between two different worlds!");
                }
                return null;
            }
            return new Element(this.distance(toLocation)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_within") && attribute.hasContext(1)) {
            if (dEllipsoid.matches(attribute.getContext(1))) {
                dEllipsoid ellipsoid = dEllipsoid.valueOf(attribute.getContext(1));
                if (ellipsoid != null) {
                    return new Element(ellipsoid.contains(this)).getAttribute(attribute.fulfill(1));
                }
            } else {
                dCuboid cuboid = dCuboid.valueOf(attribute.getContext(1));
                if (cuboid != null) {
                    return new Element(cuboid.isInsideCuboid(this)).getAttribute(attribute.fulfill(1));
                }
            }
        }
        if (attribute.startsWith("biome.formatted")) {
            return new Element(this.getBlock().getBiome().name().toLowerCase().replace('_', ' ')).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("biome.humidity")) {
            return new Element(this.getBlock().getHumidity()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("biome.temperature")) {
            return new Element(this.getBlock().getTemperature()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("biome")) {
            return new Element(this.getBlock().getBiome().name()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("cuboids")) {
            List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(this);
            dList cuboid_list = new dList();
            for (dCuboid cuboid : cuboids) {
                cuboid_list.add(cuboid.identify());
            }
            return cuboid_list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_liquid")) {
            return new Element(this.getBlock().isLiquid()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("light.from_blocks") || attribute.startsWith("light.blocks")) {
            return new Element(this.getBlock().getLightFromBlocks()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("light.from_sky") || attribute.startsWith("light.sky")) {
            return new Element(this.getBlock().getLightFromSky()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("light")) {
            return new Element(this.getBlock().getLightLevel()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("power")) {
            return new Element(this.getBlock().getBlockPower()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element("Location").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("command_block_name") && this.getBlock().getType() == Material.COMMAND) {
            return new Element(((CommandBlock)this.getBlock().getState()).getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("command_block") && this.getBlock().getType() == Material.COMMAND) {
            return new Element(((CommandBlock)this.getBlock().getState()).getCommand()).getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    public void applyProperty(Mechanism mechanism) {
        dB.echoError("Cannot apply properties to an location!");
    }

    public void adjust(Mechanism mechanism) {
        CommandBlock block;
        Sign state;
        Element value = mechanism.getValue();
        if (mechanism.matches("block_type") && mechanism.requireObject(dMaterial.class)) {
            dMaterial mat = value.asType(dMaterial.class);
            byte data = mat.hasData() ? mat.getData() : (byte)0;
            this.getBlock().setTypeIdAndData(mat.getMaterial().getId(), data, false);
        }
        if (mechanism.matches("biome") && mechanism.requireEnum(false, (Enum<?>[])Biome.values())) {
            this.getBlock().setBiome(Biome.valueOf((String)value.asString().toUpperCase()));
        }
        if (mechanism.matches("spawner_type") && mechanism.requireObject(dEntity.class) && this.getBlock().getState() instanceof CreatureSpawner) {
            ((CreatureSpawner)this.getBlock().getState()).setSpawnedType(value.asType(dEntity.class).getEntityType());
        }
        if (mechanism.matches("sign_contents") && this.getBlock().getState() instanceof Sign) {
            state = (Sign)this.getBlock().getState();
            for (int i = 0; i < 4; ++i) {
                state.setLine(i, "");
            }
            dList list = value.asType(dList.class);
            if (list.size() > 4) {
                dB.echoError("Sign can only hold four lines!");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    state.setLine(i, EscapeTags.unEscape((String)list.get(i)));
                }
            }
            state.update();
        }
        if (mechanism.matches("skull_skin") && this.getBlock().getState() instanceof Skull) {
            state = (Skull)this.getBlock().getState();
            if (!state.setOwner(value.asString())) {
                dB.echoError("Failed to set skull_skin!");
            }
            state.update(true);
        }
        if (mechanism.matches("command_block_name") && this.getBlock().getType() == Material.COMMAND) {
            block = (CommandBlock)this.getBlock().getState();
            block.setName(value.asString());
            block.update();
        }
        if (mechanism.matches("command_block") && this.getBlock().getType() == Material.COMMAND) {
            block = (CommandBlock)this.getBlock().getState();
            block.setCommand(value.asString());
            block.update();
        }
        if (mechanism.matches("data") && mechanism.hasValue()) {
            this.getBlock().setData((byte)value.asInt());
        }
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }
}

