/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Tameable;

public class EntityTame
implements Property {
    dEntity entity;

    public static boolean describes(dObject entity) {
        return entity instanceof dEntity && ((dEntity)entity).getBukkitEntity() instanceof Tameable;
    }

    public static EntityTame getFrom(dObject entity) {
        if (!EntityTame.describes(entity)) {
            return null;
        }
        return new EntityTame((dEntity)entity);
    }

    private EntityTame(dEntity tame) {
        this.entity = tame;
    }

    public String getPropertyString() {
        if (((Tameable)this.entity.getBukkitEntity()).isTamed()) {
            OfflinePlayer owner = (OfflinePlayer)((Tameable)this.entity.getBukkitEntity()).getOwner();
            if (owner == null) {
                return "true";
            }
            return "true|" + owner.getName();
        }
        return null;
    }

    public String getPropertyId() {
        return "tame";
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("is_tamed")) {
            return new Element(((Tameable)this.entity.getBukkitEntity()).isTamed()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("get_owner")) {
            if (((Tameable)this.entity.getBukkitEntity()).isTamed()) {
                return new dPlayer((OfflinePlayer)((Tameable)this.entity.getBukkitEntity()).getOwner()).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        return null;
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("tame")) {
            dList list = mechanism.getValue().asType(dList.class);
            if (list.size() == 0) {
                dB.echoError("Missing value for 'tame' mechanism!");
                return;
            }
            if (new Element((String)list.get(0)).isBoolean()) {
                ((Tameable)this.entity.getBukkitEntity()).setTamed(mechanism.getValue().asBoolean());
            } else {
                dB.echoError("Invalid boolean value!");
            }
            if (list.size() > 1 && new Element((String)list.get(1)).matchesType(dPlayer.class)) {
                ((Tameable)this.entity.getBukkitEntity()).setOwner((AnimalTamer)new Element((String)list.get(1)).asType(dPlayer.class).getOfflinePlayer());
            }
        }
        if (mechanism.matches("owner")) {
            if (mechanism.hasValue() && mechanism.requireObject(dPlayer.class)) {
                ((Tameable)this.entity.getBukkitEntity()).setOwner((AnimalTamer)mechanism.getValue().asType(dPlayer.class).getOfflinePlayer());
            } else {
                ((Tameable)this.entity.getBukkitEntity()).setOwner(null);
            }
        }
    }
}

