/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizen.utilities.entity.EntityMovement;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.Holdable;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.ai.event.NavigationEvent;
import net.citizensnpcs.api.ai.flocking.AlignmentBehavior;
import net.citizensnpcs.api.ai.flocking.CohesionBehavior;
import net.citizensnpcs.api.ai.flocking.FlockBehavior;
import net.citizensnpcs.api.ai.flocking.Flocker;
import net.citizensnpcs.api.ai.flocking.NPCFlock;
import net.citizensnpcs.api.ai.flocking.RadiusNPCFlock;
import net.citizensnpcs.api.ai.flocking.SeparationBehavior;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class WalkCommand
extends AbstractCommand
implements Listener,
Holdable {
    public static List<ScriptEntry> held = new ArrayList<ScriptEntry>();

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("speed") && arg.matchesPrimitive(aH.PrimitiveType.Percentage) && arg.matchesPrefix("s, speed")) {
                scriptEntry.addObject("speed", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("auto_range") && arg.matches("auto_range")) {
                scriptEntry.addObject("auto_range", Element.TRUE);
                continue;
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesPrimitive(aH.PrimitiveType.Double) && arg.matchesPrefix("radius")) {
                scriptEntry.addObject("radius", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("entities", arg.asType(dList.class).filter(dEntity.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        if (!scriptEntry.hasObject("entities")) {
            if (((BukkitScriptEntryData)scriptEntry.entryData).getNPC() == null || !((BukkitScriptEntryData)scriptEntry.entryData).getNPC().isValid() || !((BukkitScriptEntryData)scriptEntry.entryData).getNPC().isSpawned()) {
                throw new InvalidArgumentsException("Must have a valid spawned NPC attached.");
            }
            scriptEntry.addObject("entities", Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getNPC()));
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation loc = (dLocation)scriptEntry.getObject("location");
        Element speed = scriptEntry.getElement("speed");
        Element auto_range = scriptEntry.getElement("auto_range");
        Element radius = scriptEntry.getElement("radius");
        List entities = (List)scriptEntry.getObject("entities");
        dB.report(scriptEntry, this.getName(), loc.debug() + (speed != null ? speed.debug() : "") + (auto_range != null ? auto_range.debug() : "") + (radius != null ? radius.debug() : "") + aH.debugObj("entities", entities));
        ArrayList<dNPC> npcs = new ArrayList<dNPC>();
        for (dEntity entity : entities) {
            if (entity.isNPC()) {
                dNPC npc = entity.getDenizenNPC();
                npcs.add(npc);
                if (!npc.isSpawned()) {
                    dB.echoError(scriptEntry.getResidingQueue(), "NPC " + npc.identify() + " is not spawned!");
                    continue;
                }
                if (auto_range != null && auto_range == Element.TRUE) {
                    double distance = npc.getLocation().distance(loc);
                    if ((double)npc.getNavigator().getLocalParameters().range() < distance + 10.0) {
                        npc.getNavigator().getLocalParameters().range((float)distance + 10.0f);
                    }
                }
                npc.getNavigator().setTarget((Location)loc);
                if (speed != null) {
                    npc.getNavigator().getLocalParameters().speedModifier(speed.asFloat());
                }
                if (radius == null) continue;
                RadiusNPCFlock flock = new RadiusNPCFlock(radius.asDouble());
                Flocker flocker = new Flocker(npc.getCitizen(), (NPCFlock)flock, new FlockBehavior[]{new SeparationBehavior(Flocker.LOW_INFLUENCE), new CohesionBehavior(Flocker.LOW_INFLUENCE), new AlignmentBehavior(Flocker.HIGH_INFLUENCE)});
                npc.getNavigator().getLocalParameters().addRunCallback((Runnable)flocker);
                continue;
            }
            EntityMovement.walkTo(entity.getBukkitEntity(), loc, speed != null ? speed.asDouble() : 0.2);
        }
        if (scriptEntry.shouldWaitFor()) {
            held.add(scriptEntry);
            scriptEntry.addObject("tally", npcs);
        }
    }

    @EventHandler
    public void finish(NavigationCompleteEvent e) {
        if (held.isEmpty()) {
            return;
        }
        this.checkHeld((NavigationEvent)e);
    }

    @EventHandler
    public void cancel(NavigationCancelEvent e) {
        if (held.isEmpty()) {
            return;
        }
        this.checkHeld((NavigationEvent)e);
    }

    public void checkHeld(NavigationEvent e) {
        if (e.getNPC() == null) {
            return;
        }
        for (int i = 0; i < held.size(); ++i) {
            ScriptEntry entry = held.get(i);
            List tally = (List)entry.getObject("tally");
            tally.remove(dNPC.mirrorCitizensNPC(e.getNPC()));
            if (!tally.isEmpty()) continue;
            entry.setFinished(true);
            held.remove(i);
            --i;
        }
    }

    public void onEnable() {
        if (Depends.citizens != null) {
            DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        }
    }
}

