/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.item;

import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizen.utilities.nbt.CustomNBT;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class GiveCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("qty") && arg.matchesPrefix("q", "qty", "quantity") && arg.matchesPrimitive(aH.PrimitiveType.Double)) {
                scriptEntry.addObject("qty", arg.asElement());
                scriptEntry.addObject("set_quantity", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("money", "coins")) {
                scriptEntry.addObject("type", (Object)Type.MONEY);
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("xp", "exp", "experience")) {
                scriptEntry.addObject("type", (Object)Type.EXP);
                continue;
            }
            if (!scriptEntry.hasObject("engrave") && arg.matches("engrave")) {
                scriptEntry.addObject("engrave", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("unlimit_stack_size") && arg.matches("unlimit_stack_size")) {
                scriptEntry.addObject("unlimit_stack_size", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("items") && !scriptEntry.hasObject("type") && arg.matchesArgumentList(dItem.class)) {
                scriptEntry.addObject("items", dList.valueOf(arg.raw_value.replace("item:", "")).filter(dItem.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("inventory") && arg.matchesPrefix("t", "to") && arg.matchesArgumentType(dInventory.class)) {
                scriptEntry.addObject("inventory", arg.asType(dInventory.class));
                continue;
            }
            if (!scriptEntry.hasObject("slot") && arg.matchesPrefix("slot") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("slot", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("type", new Object[]{Type.ITEM}).defaultObject("engrave", new Element(false)).defaultObject("unlimit_stack_size", new Element(false)).defaultObject("qty", new Element(1)).defaultObject("slot", new Element(1));
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        if (type != Type.MONEY && scriptEntry.getObject("inventory") == null) {
            scriptEntry.addObject("inventory", ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() ? ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getInventory() : null);
        }
        if (!scriptEntry.hasObject("inventory") && type != Type.MONEY) {
            throw new InvalidArgumentsException("Must specify an inventory to give to!");
        }
        if (type == Type.ITEM && scriptEntry.getObject("items") == null) {
            throw new InvalidArgumentsException("Must specify item/items!");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element engrave = scriptEntry.getElement("engrave");
        Element unlimit_stack_size = scriptEntry.getElement("unlimit_stack_size");
        dInventory inventory = (dInventory)scriptEntry.getObject("inventory");
        Element qty = scriptEntry.getElement("qty");
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        Element slot = scriptEntry.getElement("slot");
        Object items_object = scriptEntry.getObject("items");
        List items = null;
        if (items_object != null) {
            items = (List)items_object;
        }
        dB.report(scriptEntry, this.getName(), aH.debugObj("Type", type.name()) + (inventory != null ? inventory.debug() : "") + aH.debugObj("Quantity", qty.asDouble()) + engrave.debug() + unlimit_stack_size.debug() + (items != null ? aH.debugObj("Items", items) : "") + slot.debug());
        switch (type) {
            case MONEY: {
                if (Depends.economy != null) {
                    Depends.economy.depositPlayer(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getName(), qty.asDouble());
                    break;
                }
                dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                break;
            }
            case EXP: {
                ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getPlayerEntity().giveExp(qty.asInt());
                break;
            }
            case ITEM: {
                boolean set_quantity = scriptEntry.hasObject("set_quantity");
                boolean limited = !unlimit_stack_size.asBoolean();
                for (dItem item : items) {
                    List<ItemStack> leftovers;
                    ItemStack is = item.getItemStack();
                    if (is.getType() == Material.AIR) {
                        dB.echoError("Cannot give air!");
                        continue;
                    }
                    if (set_quantity) {
                        is.setAmount(qty.asInt());
                    }
                    if (engrave.asBoolean()) {
                        is = CustomNBT.addCustomNBT(item.getItemStack(), "owner", ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getName());
                    }
                    if ((leftovers = inventory.addWithLeftovers(slot.asInt() - 1, limited, is)).isEmpty()) continue;
                    dB.echoDebug((Debuggable)scriptEntry, "The inventory didn't have enough space, the rest of the items have been placed on the floor.");
                    for (ItemStack leftoverItem : leftovers) {
                        inventory.getLocation().getWorld().dropItem((Location)inventory.getLocation(), leftoverItem);
                    }
                }
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        ITEM,
        MONEY,
        EXP;

    }
}

