/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.npc;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.citizensnpcs.api.npc.NPC;

public class VulnerableCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Toggle vulnerable = Toggle.TRUE;
        for (String arg : scriptEntry.getArguments()) {
            if (!aH.matchesState(arg)) continue;
            vulnerable = Toggle.valueOf(aH.getStringFrom(arg).toUpperCase());
        }
        if (((BukkitScriptEntryData)scriptEntry.entryData).getNPC() == null) {
            throw new InvalidArgumentsException("This command requires a linked NPC!");
        }
        scriptEntry.addObject("vulnerable", (Object)vulnerable);
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Toggle toggle = (Toggle)((Object)scriptEntry.getObject("vulnerable"));
        dB.report(scriptEntry, this.getName(), aH.debugObj("NPC", ((BukkitScriptEntryData)scriptEntry.entryData).getNPC().toString()) + aH.debugObj("Toggle", toggle.toString()));
        NPC npc = ((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getCitizen();
        boolean vulnerable = toggle == Toggle.TOGGLE ? (Boolean)npc.data().get("protected", (Object)true) == false : Boolean.valueOf(toggle.toString());
        npc.data().set("protected", (Object)(!vulnerable ? 1 : 0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Toggle {
        TRUE,
        FALSE,
        TOGGLE;

    }
}

