/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.player;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.entity.EntityType;

public class StatisticCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        Statistic.Type type;
        boolean specified_players = false;
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            if (arg.matchesPrefix("players") && !scriptEntry.hasObject("players") && arg.matchesArgumentList(dPlayer.class)) {
                scriptEntry.addObject("players", arg.asType(dList.class));
                specified_players = true;
                continue;
            }
            if (!scriptEntry.hasObject("statistic") && arg.matchesEnum((Enum<?>[])Statistic.values())) {
                scriptEntry.addObject("statistic", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("amount") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("amount", arg.asElement());
                continue;
            }
            if (!arg.matchesPrefix("qualifier", "q") || scriptEntry.hasObject("material") || scriptEntry.hasObject("entity")) continue;
            if (arg.matchesArgumentType(dMaterial.class)) {
                scriptEntry.addObject("material", arg.asType(dMaterial.class));
                continue;
            }
            if (!arg.matchesArgumentType(dEntity.class)) continue;
            scriptEntry.addObject("entity", arg.asType(dEntity.class));
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify a valid action!");
        }
        if (!scriptEntry.hasObject("statistic")) {
            throw new InvalidArgumentsException("Must specify a valid Statistic!");
        }
        if (!scriptEntry.hasObject("amount")) {
            scriptEntry.addObject("amount", new Element(1));
        }
        if ((type = Statistic.valueOf((String)scriptEntry.getElement("statistic").asString().toUpperCase()).getType()) != Statistic.Type.UNTYPED) {
            if (!(type != Statistic.Type.BLOCK && type != Statistic.Type.ITEM || scriptEntry.hasObject("material"))) {
                throw new InvalidArgumentsException("Must specify a valid " + type.name() + " MATERIAL!");
            }
            if (type == Statistic.Type.ENTITY && !scriptEntry.hasObject("entity")) {
                throw new InvalidArgumentsException("Must specify a valid ENTITY!");
            }
        }
        if (!scriptEntry.hasObject("players") && ((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer() && !specified_players) {
            scriptEntry.addObject("players", new dList(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().identify()));
        }
        if (!scriptEntry.hasObject("players")) {
            throw new InvalidArgumentsException("Must specify valid players!");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        block20: {
            Element action = scriptEntry.getElement("action");
            dList players = (dList)scriptEntry.getdObject("players");
            Element statistic = scriptEntry.getElement("statistic");
            Element amount = scriptEntry.getElement("amount");
            dMaterial material = (dMaterial)scriptEntry.getdObject("material");
            dEntity entity = (dEntity)scriptEntry.getdObject("entity");
            dB.report(scriptEntry, this.getName(), action.debug() + statistic.debug() + amount.debug() + players.debug() + (material != null ? material.debug() : (entity != null ? entity.debug() : "")));
            Action act = Action.valueOf(action.asString().toUpperCase());
            Statistic stat = Statistic.valueOf((String)statistic.asString().toUpperCase());
            int amt = amount.asInt();
            block0 : switch (stat.getType()) {
                case BLOCK: 
                case ITEM: {
                    Material mat = material.getMaterial();
                    switch (act) {
                        case ADD: {
                            for (dPlayer player : players.filter(dPlayer.class)) {
                                player.incrementStatistic(stat, mat, amt);
                            }
                            break block0;
                        }
                        case TAKE: {
                            for (dPlayer player : players.filter(dPlayer.class)) {
                                player.decrementStatistic(stat, mat, amt);
                            }
                            break block0;
                        }
                        case SET: {
                            for (dPlayer player : players.filter(dPlayer.class)) {
                                player.setStatistic(stat, mat, amt);
                            }
                        }
                    }
                    break;
                }
                case ENTITY: {
                    EntityType ent = entity.getEntityType();
                    switch (act) {
                        case ADD: {
                            for (dPlayer player : players.filter(dPlayer.class)) {
                                player.incrementStatistic(stat, ent, amt);
                            }
                            break block20;
                        }
                        case TAKE: {
                            for (dPlayer player : players.filter(dPlayer.class)) {
                                player.decrementStatistic(stat, ent, amt);
                            }
                            break block20;
                        }
                        case SET: {
                            for (dPlayer player : players.filter(dPlayer.class)) {
                                player.setStatistic(stat, ent, amt);
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        ADD,
        TAKE,
        SET;

    }
}

