/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEllipsoid;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.Holdable;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.InstantQueue;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_8_R1.CraftWorld;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyBlockCommand
extends AbstractCommand
implements Listener,
Holdable {
    private static Field isStaticField = null;
    boolean no_physics = false;
    public final List<Location> block_physics = new ArrayList<Location>();
    long tick = 0L;
    long physitick = 0L;

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matchesArgumentType(dCuboid.class) && !scriptEntry.hasObject("locations") && !scriptEntry.hasObject("location_list")) {
                scriptEntry.addObject("locations", arg.asType(dCuboid.class).getBlockLocations());
                continue;
            }
            if (arg.matchesArgumentType(dEllipsoid.class) && !scriptEntry.hasObject("locations") && !scriptEntry.hasObject("location_list")) {
                scriptEntry.addObject("locations", arg.asType(dEllipsoid.class).getBlockLocations());
                continue;
            }
            if (arg.matchesArgumentList(dLocation.class) && !scriptEntry.hasObject("locations") && !scriptEntry.hasObject("location_list")) {
                scriptEntry.addObject("location_list", arg.asType(dList.class));
                continue;
            }
            if (!scriptEntry.hasObject("materials") && arg.matchesArgumentList(dMaterial.class)) {
                scriptEntry.addObject("materials", arg.asType(dList.class));
                continue;
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesPrefix("radius", "r") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("radius", new Element(arg.getValue()));
                continue;
            }
            if (!scriptEntry.hasObject("height") && arg.matchesPrefix("height", "h") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("height", new Element(arg.getValue()));
                continue;
            }
            if (!scriptEntry.hasObject("depth") && arg.matchesPrefix("depth", "d") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("depth", new Element(arg.getValue()));
                continue;
            }
            if (arg.matches("no_physics")) {
                scriptEntry.addObject("physics", new Element(false));
                continue;
            }
            if (arg.matches("naturally")) {
                scriptEntry.addObject("natural", new Element(true));
                continue;
            }
            if (arg.matches("delayed")) {
                scriptEntry.addObject("delayed", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("script") && arg.matchesArgumentType(dScript.class)) {
                scriptEntry.addObject("script", arg.asType(dScript.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("materials")) {
            throw new InvalidArgumentsException("Missing material argument!");
        }
        if (!scriptEntry.hasObject("locations") && !scriptEntry.hasObject("location_list")) {
            throw new InvalidArgumentsException("Missing location argument!");
        }
        scriptEntry.defaultObject("radius", new Element(0)).defaultObject("height", new Element(0)).defaultObject("depth", new Element(0)).defaultObject("physics", new Element(true)).defaultObject("natural", new Element(false)).defaultObject("delayed", new Element(false));
    }

    @Override
    public void execute(final ScriptEntry scriptEntry) throws CommandExecutionException {
        dList materials = (dList)scriptEntry.getdObject("materials");
        final List locations = (List)scriptEntry.getObject("locations");
        final dList location_list = (dList)scriptEntry.getdObject("location_list");
        Element physics = scriptEntry.getElement("physics");
        Element natural = scriptEntry.getElement("natural");
        Element delayed = scriptEntry.getElement("delayed");
        Element radiusElement = scriptEntry.getElement("radius");
        Element heightElement = scriptEntry.getElement("height");
        Element depthElement = scriptEntry.getElement("depth");
        final dScript script = (dScript)scriptEntry.getdObject("script");
        final List<dMaterial> materialList = materials.filter(dMaterial.class);
        dB.report(scriptEntry, this.getName(), (locations == null ? location_list.debug() : aH.debugList("locations", locations)) + materials.debug() + physics.debug() + radiusElement.debug() + heightElement.debug() + depthElement.debug() + natural.debug() + delayed.debug() + (script != null ? script.debug() : ""));
        final boolean doPhysics = physics.asBoolean();
        final boolean isNatural = natural.asBoolean();
        final int radius = radiusElement.asInt();
        final int height = heightElement.asInt();
        final int depth = depthElement.asInt();
        if (!(locations != null && locations.size() != 0 || location_list != null && location_list.size() != 0)) {
            dB.echoError("Must specify a valid location!");
        }
        if (materialList.size() == 0) {
            dB.echoError("Must specify a valid material!");
        }
        boolean bl = this.no_physics = !doPhysics;
        if (delayed.asBoolean()) {
            new BukkitRunnable(){
                int index = 0;

                public void run() {
                    long start = System.currentTimeMillis();
                    dLocation loc = locations != null ? (dLocation)locations.get(0) : dLocation.valueOf((String)location_list.get(0));
                    boolean was_static = ModifyBlockCommand.this.preSetup(loc);
                    while (locations != null && locations.size() > this.index || location_list != null && location_list.size() > this.index) {
                        dLocation nLoc = locations != null ? (dLocation)locations.get(this.index) : dLocation.valueOf((String)location_list.get(this.index));
                        ModifyBlockCommand.this.handleLocation(nLoc, this.index, materialList, doPhysics, isNatural, radius, height, depth);
                        ++this.index;
                        if (System.currentTimeMillis() - start <= 50L) continue;
                        break;
                    }
                    ModifyBlockCommand.this.postComplete(loc, was_static);
                    if (locations != null && locations.size() == this.index || location_list != null && location_list.size() == this.index) {
                        if (script != null) {
                            List<ScriptEntry> entries = script.getContainer().getBaseEntries(scriptEntry.entryData.clone());
                            ScriptQueue queue = InstantQueue.getQueue(ScriptQueue.getNextId(script.getContainer().getName())).addEntries(entries);
                            queue.start();
                        }
                        scriptEntry.setFinished(true);
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)DenizenAPI.getCurrentInstance(), 1L, 1L);
        } else {
            dLocation loc = locations != null ? (dLocation)locations.get(0) : dLocation.valueOf((String)location_list.get(0));
            boolean was_static = this.preSetup(loc);
            int index = 0;
            if (locations != null) {
                for (dLocation obj : locations) {
                    this.handleLocation(obj, index, materialList, doPhysics, isNatural, radius, height, depth);
                    ++index;
                }
            } else {
                for (String str : location_list) {
                    this.handleLocation(dLocation.valueOf(str), index, materialList, doPhysics, isNatural, radius, height, depth);
                    ++index;
                }
            }
            this.postComplete(loc, was_static);
            scriptEntry.setFinished(true);
        }
    }

    boolean preSetup(dLocation loc0) {
        CraftWorld craftWorld = (CraftWorld)loc0.getWorld();
        boolean was_static = craftWorld.getHandle().isStatic;
        if (this.no_physics) {
            this.setWorldIsStatic(loc0.getWorld(), true);
        }
        return was_static;
    }

    void postComplete(Location loc, boolean was_static) {
        if (this.no_physics) {
            this.setWorldIsStatic(loc.getWorld(), was_static);
        }
        this.no_physics = false;
    }

    void setWorldIsStatic(World world, boolean isStatic) {
        try {
            CraftWorld craftWorld = (CraftWorld)world;
            if (isStaticField == null) {
                isStaticField = craftWorld.getHandle().getClass().getField("isStatic");
                isStaticField.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(isStaticField, isStaticField.getModifiers() & 0xFFFFFFEF);
            }
            isStaticField.set(craftWorld.getHandle(), isStatic);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    void handleLocation(dLocation location, int index, List<dMaterial> materialList, boolean doPhysics, boolean isNatural, int radius, int height, int depth) {
        int y;
        int z;
        int x;
        dMaterial material = materialList.get(index % materialList.size());
        World world = location.getWorld();
        location.setX(location.getBlockX());
        location.setY(location.getBlockY());
        location.setZ(location.getBlockZ());
        this.setBlock(location, material, doPhysics, isNatural);
        if (radius != 0) {
            for (x = 0; x < 2 * radius + 1; ++x) {
                for (z = 0; z < 2 * radius + 1; ++z) {
                    this.setBlock(new Location(world, location.getX() + (double)x - (double)radius, location.getY(), location.getZ() + (double)z - (double)radius), material, doPhysics, isNatural);
                }
            }
        }
        if (height != 0) {
            for (x = 0; x < 2 * radius + 1; ++x) {
                for (z = 0; z < 2 * radius + 1; ++z) {
                    for (y = 1; y < height + 1; ++y) {
                        this.setBlock(new Location(world, location.getX() + (double)x - (double)radius, location.getY() + (double)y, location.getZ() + (double)z - (double)radius), material, doPhysics, isNatural);
                    }
                }
            }
        }
        if (depth != 0) {
            for (x = 0; x < 2 * radius + 1; ++x) {
                for (z = 0; z < 2 * radius + 1; ++z) {
                    for (y = 1; y < depth + 1; ++y) {
                        this.setBlock(new Location(world, location.getX() + (double)x - (double)radius, location.getY() - (double)y, location.getZ() + (double)z - (double)radius), material, doPhysics, isNatural);
                    }
                }
            }
        }
    }

    void setBlock(Location location, dMaterial material, boolean physics, boolean natural) {
        if (physics) {
            for (int i = 0; i < this.block_physics.size(); ++i) {
                if (!this.compareloc(this.block_physics.get(i), location)) continue;
                this.block_physics.remove(i--);
            }
        } else {
            this.block_physics.add(location);
            this.physitick = this.tick;
        }
        if (location.getY() < 0.0 || location.getY() > 255.0) {
            dB.echoError("Invalid modifyblock location: " + new dLocation(location).toString());
            return;
        }
        if (natural && material.getMaterial() == Material.AIR) {
            location.getBlock().breakNaturally();
        } else {
            location.getBlock().setTypeIdAndData(material.getMaterial().getId(), material.getMaterialData().getData(), physics);
        }
    }

    @Override
    public void onEnable() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                ++ModifyBlockCommand.this.tick;
                if (ModifyBlockCommand.this.physitick < ModifyBlockCommand.this.tick - 1L) {
                    ModifyBlockCommand.this.block_physics.clear();
                }
            }
        }, 2L, 2L);
    }

    @EventHandler
    public void blockPhysics(BlockPhysicsEvent event) {
        if (this.no_physics) {
            event.setCancelled(true);
        }
        for (Location loc : this.block_physics) {
            if (!this.compareloc(event.getBlock().getLocation(), loc)) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockChanges(EntityChangeBlockEvent event) {
        if (event.getEntity().getType() != EntityType.FALLING_BLOCK) {
            return;
        }
        if (this.no_physics) {
            event.setCancelled(true);
        }
        for (Location loc : this.block_physics) {
            if (!this.compareloc(event.getBlock().getLocation(), loc)) continue;
            event.setCancelled(true);
        }
    }

    boolean compareloc(Location lone, Location ltwo) {
        return lone.getBlockX() == ltwo.getBlockX() && lone.getBlockY() == ltwo.getBlockY() && lone.getBlockZ() == ltwo.getBlockZ() && lone.getWorld().getName().equalsIgnoreCase(ltwo.getWorld().getName());
    }
}

