/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;

public class EntityScriptHelper
implements Listener {
    static HashMap<UUID, String> entities = new HashMap();

    public EntityScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        EntityScriptHelper.unlinkEntity((Entity)event.getEntity());
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        for (Entity ent : event.getChunk().getEntities()) {
            if (ent instanceof LivingEntity && !((LivingEntity)ent).getRemoveWhenFarAway()) continue;
            EntityScriptHelper.unlinkEntity(ent);
        }
    }

    public static void reloadEntities() {
        entities.clear();
        ConfigurationSection entity_scripts = DenizenAPI.getCurrentInstance().getEntities().getConfigurationSection("entities.scripts");
        if (entity_scripts == null) {
            return;
        }
        for (String Path2 : entity_scripts.getKeys(false)) {
            UUID id = UUID.fromString(Path2);
            String scriptname = entity_scripts.getString(Path2 + ".scriptname");
            entities.put(id, scriptname);
        }
    }

    public static void saveEntities() {
        FileConfiguration entityScripts = DenizenAPI.getCurrentInstance().getEntities();
        entityScripts.set("entities.scripts", null);
        for (Map.Entry<UUID, String> entry : entities.entrySet()) {
            entityScripts.set("entities.scripts." + entry.getKey() + ".scriptname", (Object)entry.getValue());
        }
    }

    public static boolean entityHasScript(Entity ent) {
        return EntityScriptHelper.getEntityScript(ent) != null;
    }

    public static String getEntityScript(Entity ent) {
        if (ent == null) {
            return null;
        }
        return EntityScriptHelper.getEntityScript(ent.getUniqueId());
    }

    public static String getEntityScript(UUID entID) {
        if (entID == null) {
            return null;
        }
        return entities.get(entID);
    }

    public static void setEntityScript(Entity ent, String script) {
        if (ent == null || ent.getUniqueId() == null || script == null) {
            return;
        }
        entities.put(ent.getUniqueId(), script);
    }

    public static void unlinkEntity(Entity ent) {
        if (ent == null || ent.getUniqueId() == null) {
            return;
        }
        entities.remove(ent.getUniqueId());
    }
}

