/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.BookScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptHelper;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.nbt.LeatherColorer;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemScriptContainer
extends ScriptContainer {
    public static Map<dItem, dList> specialrecipesMap = new HashMap<dItem, dList>();
    public static Map<dItem, dList> shapelessRecipesMap = new HashMap<dItem, dList>();
    dNPC npc = null;
    dPlayer player = null;
    public boolean bound = false;
    String hash = "";

    public ItemScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        ItemScriptHelper.item_scripts.put(this.getName(), this);
        ItemScriptHelper.item_scripts_by_hash_id.put(ItemScriptHelper.createItemScriptID(this), this);
        if (this.contains("RECIPE")) {
            List<String> recipeList = this.getStringList("RECIPE");
            for (int n = 0; n < recipeList.size(); ++n) {
                recipeList.set(n, TagManager.tag(recipeList.get(n), new BukkitTagContext(this.player, this.npc, false, null, dB.shouldDebug(this), new dScript(this))));
            }
            dList ingredients = new dList();
            for (String recipeRow : recipeList) {
                String[] elements;
                for (String element : elements = recipeRow.split("\\|", 3)) {
                    ingredients.add(element.replaceAll("[iImM]@", ""));
                }
            }
            specialrecipesMap.put(this.getItemFrom(), ingredients);
        }
        if (this.contains("SHAPELESS_RECIPE")) {
            String list = TagManager.tag(this.getString("SHAPELESS_RECIPE"), new BukkitTagContext(this.player, this.npc, false, null, dB.shouldDebug(this), new dScript(this)));
            dList actual_list = dList.valueOf(list);
            shapelessRecipesMap.put(this.getItemFrom(), actual_list);
        }
        if (this.contains("FURNACE_RECIPE")) {
            dItem furnace_item = dItem.valueOf(this.getString("FURNACE_RECIPE"));
            if (furnace_item == null) {
                dB.echoError("Invalid item '" + this.getString("FURNACE_RECIPE") + "'");
                return;
            }
            FurnaceRecipe recipe = new FurnaceRecipe(this.getItemFrom().getItemStack(), furnace_item.getMaterial().getMaterial(), (int)furnace_item.getItemStack().getDurability());
            Bukkit.getServer().addRecipe((Recipe)recipe);
        }
    }

    public String getHashID() {
        return this.hash;
    }

    public void setHashID(String HashID) {
        this.hash = HashID;
    }

    public dItem getItemFrom() {
        return this.getItemFrom(null, null);
    }

    public dItem getItemFrom(dPlayer player, dNPC npc) {
        dItem stack = null;
        try {
            boolean debug = true;
            if (this.contains("DEBUG")) {
                debug = Boolean.valueOf(this.getString("DEBUG"));
            }
            if (this.contains("MATERIAL")) {
                String material = TagManager.tag(this.getString("MATERIAL"), new BukkitTagContext(player, npc, false, null, debug, new dScript(this)));
                if (material.startsWith("m@")) {
                    material = material.substring(2);
                }
                stack = dItem.valueOf(material);
            }
            if (stack == null) {
                return null;
            }
            ItemMeta meta = stack.getItemStack().getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            boolean hideLore = false;
            if (this.contains("NO_ID")) {
                hideLore = Boolean.valueOf(this.getString("NO_ID"));
            }
            if (!hideLore) {
                lore.add(this.hash);
            }
            if (this.contains("DISPLAY NAME")) {
                String displayName = TagManager.tag(this.getString("DISPLAY NAME"), new BukkitTagContext(player, npc, false, null, debug, new dScript(this)));
                meta.setDisplayName(displayName);
            }
            if (this.contains("BOUND")) {
                this.bound = Boolean.valueOf(TagManager.tag(this.getString("BOUND"), new BukkitTagContext(player, npc, false, null, debug, new dScript(this))));
            }
            if (this.contains("LORE")) {
                for (String l : this.getStringList("LORE")) {
                    l = TagManager.tag(l, new BukkitTagContext(player, npc, false, null, debug, new dScript(this)));
                    lore.add(l);
                }
            }
            meta.setLore(lore);
            stack.getItemStack().setItemMeta(meta);
            if (this.contains("ENCHANTMENTS")) {
                for (String enchantment : this.getStringList("ENCHANTMENTS")) {
                    enchantment = TagManager.tag(enchantment, new BukkitTagContext(player, npc, false, null, debug, new dScript(this)));
                    try {
                        int level = 1;
                        String[] split = enchantment.split(":");
                        if (split.length > 1) {
                            level = Integer.valueOf(split[1].replace(" ", ""));
                            enchantment = split[0].replace(" ", "");
                        }
                        Enchantment ench = Enchantment.getByName((String)enchantment.toUpperCase());
                        stack.getItemStack().addUnsafeEnchantment(ench, level);
                    }
                    catch (Exception e) {
                        dB.echoError("While constructing '" + this.getName() + "', encountered error: '" + enchantment + "' is an invalid enchantment!");
                    }
                }
            }
            if (this.contains("COLOR")) {
                String color = TagManager.tag(this.getString("COLOR"), new BukkitTagContext(player, npc, false, null, debug, new dScript(this)));
                LeatherColorer.colorArmor(stack, color);
            }
            if (this.contains("BOOK")) {
                BookScriptContainer book = (BookScriptContainer)ScriptRegistry.getScriptContainer(TagManager.tag(this.getString("BOOK"), new BukkitTagContext(player, npc, false, null, debug, new dScript(this))).replace("s@", ""));
                stack = book.writeBookTo(stack, player, npc);
            }
        }
        catch (Exception e) {
            dB.echoError("Woah! An exception has been called with this item script!");
            dB.echoError(e);
            stack = null;
        }
        return stack;
    }

    public void setNPC(dNPC npc) {
        this.npc = npc;
    }

    public void setPlayer(dPlayer player) {
        this.player = player;
    }
}

