/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptContainer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemScriptHelper
implements Listener {
    public static Map<String, ItemScriptContainer> item_scripts = new ConcurrentHashMap<String, ItemScriptContainer>(8, 0.9f, 1);
    public static Map<String, ItemScriptContainer> item_scripts_by_hash_id = new HashMap<String, ItemScriptContainer>();
    public static String ItemScriptHashID = ChatColor.RED.toString() + ChatColor.BLUE + ChatColor.BLACK;

    public ItemScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public static void removeDenizenRecipes() {
        ItemScriptContainer.specialrecipesMap.clear();
        ItemScriptContainer.shapelessRecipesMap.clear();
    }

    public static boolean isBound(ItemStack item) {
        return ItemScriptHelper.isItemscript(item) && ItemScriptHelper.getItemScriptContainer((ItemStack)item).bound;
    }

    public static boolean isItemscript(ItemStack item) {
        return ItemScriptHelper.getItemScriptContainer(item) != null;
    }

    public static ItemScriptContainer getItemScriptContainer(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasLore()) {
            return null;
        }
        for (String itemLore : item.getItemMeta().getLore()) {
            if (itemLore.startsWith("\u00a70id:")) {
                return item_scripts.get(itemLore.replace("\u00a70id:", ""));
            }
            if (!itemLore.startsWith(ItemScriptHashID)) continue;
            return item_scripts_by_hash_id.get(itemLore);
        }
        return null;
    }

    public static String createItemScriptID(ItemScriptContainer container) {
        String colors = ItemScriptHelper.createItemScriptID(container.getName());
        container.setHashID(colors);
        return colors;
    }

    public static String createItemScriptID(String name) {
        String script = name.toUpperCase();
        StringBuilder colors = new StringBuilder();
        colors.append(ItemScriptHashID);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = script.getBytes("UTF-8");
            md.update(bytes, 0, bytes.length);
            String hash = new BigInteger(1, md.digest()).toString(16);
            for (int i = 0; i < 16; ++i) {
                colors.append('\u00a7').append(hash.charAt(i));
            }
        }
        catch (Exception ex) {
            dB.echoError(ex);
            colors.append(ChatColor.BLUE);
        }
        return colors.toString();
    }

    @EventHandler
    public void specialRecipeClick(InventoryClickEvent event) {
        if (ItemScriptContainer.specialrecipesMap.isEmpty() && ItemScriptContainer.shapelessRecipesMap.isEmpty()) {
            return;
        }
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        InventoryType.SlotType slotType = event.getSlotType();
        if (slotType.equals((Object)InventoryType.SlotType.CRAFTING) || slotType.equals((Object)InventoryType.SlotType.RESULT)) {
            CraftingInventory inventory = (CraftingInventory)event.getInventory();
            Player player = (Player)event.getWhoClicked();
            if (slotType.equals((Object)InventoryType.SlotType.RESULT) && event.isShiftClick()) {
                this.emulateSpecialRecipeResultShiftClick(inventory, player);
            } else {
                this.processSpecialRecipes(inventory, player);
            }
        }
    }

    @EventHandler
    public void specialRecipeDrag(InventoryDragEvent event) {
        if (ItemScriptContainer.specialrecipesMap.isEmpty() && ItemScriptContainer.shapelessRecipesMap.isEmpty()) {
            return;
        }
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        for (Integer slot : event.getInventorySlots()) {
            if (slot >= 10) continue;
            CraftingInventory inventory = (CraftingInventory)event.getInventory();
            Player player = (Player)event.getWhoClicked();
            this.processSpecialRecipes(inventory, player);
            break;
        }
    }

    public void processSpecialRecipes(final CraftingInventory inventory, final Player player) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                ItemStack[] matrix = inventory.getMatrix();
                dItem result = ItemScriptHelper.this.getSpecialRecipeResult(matrix);
                if (result != null) {
                    HashMap<String, dObject> context = new HashMap<String, dObject>();
                    context.put("inventory", new dInventory((Inventory)inventory));
                    context.put("item", result);
                    dList recipeList = new dList();
                    for (ItemStack item : inventory.getMatrix()) {
                        if (item != null) {
                            recipeList.add(new dItem(item).identify());
                            continue;
                        }
                        recipeList.add(new dItem(Material.AIR).identify());
                    }
                    context.put("recipe", recipeList);
                    List<String> determinations = OldEventManager.doEvents(Arrays.asList("item crafted", result.identifySimple() + " crafted", result.identifyMaterial() + " crafted"), new BukkitScriptEntryData(new dPlayer(player), null), context);
                    for (String determination : determinations) {
                        if (determination.toUpperCase().startsWith("CANCELLED")) {
                            return;
                        }
                        if (!dItem.matches(determination)) continue;
                        result = dItem.valueOf(determination);
                    }
                    inventory.setResult(result.getItemStack());
                    player.updateInventory();
                }
            }
        }, 0L);
    }

    public dItem getSpecialRecipeResult(ItemStack[] matrix) {
        block0: for (Map.Entry<dItem, dList> entry : ItemScriptContainer.specialrecipesMap.entrySet()) {
            for (int n = 0; n < 9; ++n) {
                dItem matrixN;
                dItem valueN = dItem.valueOf((String)entry.getValue().get(n));
                dItem dItem2 = matrixN = matrix.length <= n || matrix[n] == null ? new dItem(Material.AIR) : new dItem(matrix[n].clone());
                if (valueN.isItemscript() != matrixN.isItemscript() || (valueN.isItemscript() && matrixN.isItemscript() ? !valueN.getScriptName().equalsIgnoreCase(matrixN.getScriptName()) : !valueN.getMaterial().matchesMaterialData(matrixN.getMaterial().getMaterialData()))) continue block0;
            }
            return entry.getKey();
        }
        block2: for (Map.Entry<dItem, dList> entry : ItemScriptContainer.shapelessRecipesMap.entrySet()) {
            for (int i = 0; i < entry.getValue().size(); ++i) {
                if (!this.contains_any(dItem.valueOf((String)entry.getValue().get(i)), matrix)) continue block2;
            }
            return entry.getKey();
        }
        return null;
    }

    public boolean contains_any(dItem item, ItemStack[] matrix) {
        String full = item.getFullString();
        for (int i = 0; i < matrix.length; ++i) {
            if (!full.equalsIgnoreCase(new dItem(matrix[i]).getFullString())) continue;
            return true;
        }
        return false;
    }

    public void emulateSpecialRecipeResultShiftClick(CraftingInventory inventory, Player player) {
        ItemStack[] matrix = inventory.getMatrix();
        dItem result = this.getSpecialRecipeResult(matrix);
        if (result != null) {
            int n;
            int lowestAmount = 0;
            for (n = 0; n < matrix.length - 1; ++n) {
                if ((matrix[n].getAmount() <= 0 || matrix[n].getAmount() >= lowestAmount) && lowestAmount != 0) continue;
                lowestAmount = matrix[n].getAmount();
            }
            for (n = 0; n < matrix.length - 1; ++n) {
                if (matrix[n].getAmount() <= 0) continue;
                matrix[n].setAmount(matrix[n].getAmount() - lowestAmount + 1);
            }
            if (lowestAmount > 1) {
                ItemStack resultStack = result.getItemStack().clone();
                resultStack.setAmount(lowestAmount * resultStack.getAmount());
                inventory.setResult(resultStack);
                player.updateInventory();
            }
        }
    }

    @EventHandler
    public void boundInventoryClickEvent(InventoryClickEvent event) {
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        ItemStack item = event.getCursor();
        if (item == null || !ItemScriptHelper.isBound(item)) {
            return;
        }
        if (event.getInventory().getType() != InventoryType.PLAYER) {
            event.setCancelled(true);
            return;
        }
        if (!((Player)event.getInventory().getHolder()).getName().equalsIgnoreCase(event.getWhoClicked().getName())) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void boundInventoryDragEvent(InventoryDragEvent event) {
        if (!(event.getInventory() instanceof CraftingInventory)) {
            return;
        }
        ItemStack item = event.getOldCursor();
        if (item == null || !ItemScriptHelper.isBound(item)) {
            return;
        }
        if (event.getInventory().getType() != InventoryType.PLAYER) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void boundDropItem(PlayerDropItemEvent event) {
        if (ItemScriptHelper.isBound(event.getItemDrop().getItemStack())) {
            event.setCancelled(true);
        }
    }
}

