/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.debugging;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import sun.reflect.Reflection;

public class dB {
    public static boolean showDebug = Settings.showDebug();
    public static boolean showStackTraces = true;
    public static boolean showColor = true;
    public static boolean debugOverride = false;
    public static List<String> filter = new ArrayList<String>();
    public static boolean shouldTrim = true;
    public static boolean record = false;
    public static StringBuilder Recording = new StringBuilder();
    private static boolean ThrowErrorEvent = true;
    private static final Map<Class<?>, String> classNameCache = new WeakHashMap();

    public static void toggle() {
        showDebug = !showDebug;
    }

    public static void report(Debuggable caller, String name, String report) {
        if (!showDebug) {
            return;
        }
        dB.echo("<Y>+> <G>Executing '<Y>" + name + "<G>': " + dB.trimMessage(report), caller);
        if (caller instanceof ScriptEntry && ((BukkitScriptEntryData)((ScriptEntry)caller).entryData).hasPlayer() && FlagManager.playerHasFlag(((BukkitScriptEntryData)((ScriptEntry)caller).entryData).getPlayer(), "show_command_reports")) {
            String message = "<Y>+> <G>Executing '<Y>" + name + "<G>': " + dB.trimMessage(report);
            ((BukkitScriptEntryData)((ScriptEntry)caller).entryData).getPlayer().getPlayerEntity().sendRawMessage(message.replace("<Y>", ChatColor.YELLOW.toString()).replace("<G>", ChatColor.DARK_GRAY.toString()).replace("<A>", ChatColor.AQUA.toString()));
        }
    }

    public static void echoDebug(Debuggable caller, dB.DebugElement element) {
        if (!showDebug) {
            return;
        }
        dB.echoDebug(caller, element, null);
    }

    public static void echoDebug(Debuggable caller, dB.DebugElement element, String string) {
        if (!showDebug) {
            return;
        }
        StringBuilder sb = new StringBuilder(24);
        switch (element) {
            case Footer: {
                sb.append(ChatColor.LIGHT_PURPLE).append("+---------------------+");
                break;
            }
            case Header: {
                sb.append(ChatColor.LIGHT_PURPLE).append("+- ").append(string).append(" ---------+");
            }
        }
        dB.echo(sb.toString(), caller);
    }

    public static void echoDebug(Debuggable caller, String message) {
        if (!showDebug) {
            return;
        }
        dB.echo(ChatColor.LIGHT_PURPLE + " " + ChatColor.WHITE + dB.trimMessage(message), caller);
    }

    @Deprecated
    public static void echoDebug(String message) {
        dB.echo(message, null);
    }

    @Deprecated
    public static void echoDebug(dB.DebugElement de, String message) {
        dB.echoDebug(null, de, message);
    }

    public static void echoApproval(String message) {
        if (!showDebug) {
            return;
        }
        ConsoleSender.sendMessage(ChatColor.LIGHT_PURPLE + " " + ChatColor.GREEN + "OKAY! " + ChatColor.WHITE + message);
    }

    public static void echoError(String message) {
        dB.echoError(null, message);
    }

    public static void echoError(ScriptQueue source, String message) {
        dScript script = null;
        if (source != null && source.getEntries().size() > 0 && source.getEntries().get(0).getScript() != null) {
            script = source.getEntries().get(0).getScript();
        } else if (source != null && source.getLastEntryExecuted() != null && source.getLastEntryExecuted().getScript() != null) {
            script = source.getLastEntryExecuted().getScript();
        }
        if (ThrowErrorEvent) {
            ThrowErrorEvent = false;
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            context.put("message", new Element(message));
            if (source != null) {
                context.put("queue", source);
            }
            if (script != null) {
                context.put("script", script);
            }
            ArrayList<String> events = new ArrayList<String>();
            events.add("script generates error");
            if (script != null) {
                events.add(script.identifySimple() + " generates error");
            }
            ScriptEntry entry = source != null ? source.getLastEntryExecuted() : null;
            List<String> Determinations = OldEventManager.doEvents(events, entry != null ? entry.entryData : new BukkitScriptEntryData(null, null), context, true);
            ThrowErrorEvent = true;
            for (String Determination : Determinations) {
                if (!Determination.equalsIgnoreCase("CANCELLED")) continue;
                return;
            }
        }
        if (!showDebug) {
            return;
        }
        ConsoleSender.sendMessage(ChatColor.LIGHT_PURPLE + " " + ChatColor.RED + "ERROR" + (script != null ? " in script '" + script.getName() + "'" : "") + "! " + ChatColor.WHITE + dB.trimMessage(message));
    }

    public static void echoError(Throwable ex) {
        dB.echoError(null, ex);
    }

    public static void echoError(ScriptQueue source, Throwable ex) {
        if (ThrowErrorEvent) {
            ThrowErrorEvent = false;
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            Throwable thrown = ex;
            if (ex.getCause() != null) {
                thrown = ex.getCause();
            }
            context.put("message", new Element(thrown.getMessage()));
            context.put("type", new Element(thrown.getClass().getSimpleName()));
            context.put("queue", source);
            ScriptEntry entry = source != null ? source.getLastEntryExecuted() : null;
            List<String> Determinations = OldEventManager.doEvents(Arrays.asList("server generates exception"), entry == null ? new BukkitScriptEntryData(null, null) : entry.entryData, context);
            ThrowErrorEvent = true;
            for (String Determination : Determinations) {
                if (!Determination.equalsIgnoreCase("CANCELLED")) continue;
                return;
            }
        }
        if (!showDebug) {
            return;
        }
        if (!showStackTraces) {
            dB.echoError(source, "Exception! Enable '/denizen debug -s' for the nitty-gritty.");
        } else {
            dB.echoError(source, "Internal exception was thrown!");
            ex.printStackTrace();
            if (record) {
                String prefix = ConsoleSender.dateFormat.format(new Date()) + " [SEVERE] ";
                boolean first = true;
                while (ex != null) {
                    Recording.append(URLEncoder.encode(prefix + (first ? "" : "Caused by: ") + ex.toString() + "\n"));
                    for (StackTraceElement ste : ex.getStackTrace()) {
                        Recording.append(URLEncoder.encode(prefix + ste.toString() + "\n"));
                    }
                    if (ex.getCause() == ex) {
                        return;
                    }
                    ex = ex.getCause();
                    first = false;
                }
            }
        }
    }

    public static void log(String message) {
        if (!showDebug) {
            return;
        }
        Class caller = Reflection.getCallerClass((int)2);
        String callerName = classNameCache.get(caller);
        if (callerName == null) {
            callerName = caller.getSimpleName();
            classNameCache.put(caller, callerName);
        }
        ConsoleSender.sendMessage(ChatColor.YELLOW + "+> [" + (callerName.length() > 16 ? callerName.substring(0, 12) + "..." : callerName) + "] " + ChatColor.WHITE + dB.trimMessage(message));
    }

    public static void log(dB.DebugElement element, String string) {
        if (!showDebug) {
            return;
        }
        StringBuilder sb = new StringBuilder(24);
        switch (element) {
            case Footer: {
                sb.append(ChatColor.LIGHT_PURPLE).append("+---------------------+");
                break;
            }
            case Header: {
                sb.append(ChatColor.LIGHT_PURPLE).append("+- ").append(string).append(" ---------+");
                break;
            }
        }
        ConsoleSender.sendMessage(sb.toString());
    }

    private static String trimMessage(String message) {
        if (!shouldTrim) {
            return message;
        }
        int trimSize = Settings.trimLength();
        if (message.length() > trimSize) {
            message = message.substring(0, trimSize - 1) + "... * snip! *";
        }
        return message;
    }

    public static boolean shouldDebug(Debuggable caller) {
        boolean should_send;
        block6: {
            if (debugOverride) {
                return true;
            }
            should_send = true;
            if (caller != null) {
                try {
                    if (filter.isEmpty()) {
                        should_send = caller.shouldDebug();
                        break block6;
                    }
                    should_send = false;
                    for (String criteria : filter) {
                        if (!caller.shouldFilter(criteria)) continue;
                        should_send = true;
                        break;
                    }
                }
                catch (Exception e) {
                    should_send = true;
                }
            }
        }
        return should_send;
    }

    private static void echo(String string, Debuggable caller) {
        if (dB.shouldDebug(caller)) {
            ConsoleSender.sendMessage(string);
        }
    }

    private static class ConsoleSender {
        static CommandSender commandSender = null;
        public static SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        static boolean skipFooter = false;

        private ConsoleSender() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void sendMessage(String string) {
            if (commandSender == null) {
                commandSender = Bukkit.getServer().getConsoleSender();
            }
            if ((string = TagManager.cleanOutputFully(string.replace("<Y>", ChatColor.YELLOW.toString()).replace("<G>", ChatColor.DARK_GRAY.toString()).replace("<A>", ChatColor.AQUA.toString()))).equals(ChatColor.LIGHT_PURPLE + "+---------------------+")) {
                if (skipFooter) return;
                skipFooter = true;
            } else {
                skipFooter = false;
            }
            String[] words = string.split(" ");
            StringBuilder buffer = new StringBuilder();
            int length = 0;
            int width = Settings.consoleWidth();
            for (String word : words) {
                int strippedLength = ChatColor.stripColor((String)word).length() + 1;
                if (length + strippedLength < width) {
                    buffer.append(word).append(" ");
                    length += strippedLength;
                    continue;
                }
                length = strippedLength;
                buffer.append("\n                   ").append(word).append(" ");
            }
            String result = buffer.toString();
            if (record) {
                Recording.append(URLEncoder.encode(dateFormat.format(new Date()) + " [INFO] " + result.replace('\u00a7', '\u0001') + "\n"));
            }
            commandSender.sendMessage(showColor ? result : ChatColor.stripColor((String)result));
        }
    }
}

