/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.nbt;

import net.aufdemrand.denizen.utilities.nbt.MapOfEnchantments;
import net.minecraft.server.v1_8_R1.Entity;
import net.minecraft.server.v1_8_R1.EntityLiving;
import net.minecraft.server.v1_8_R1.NBTTagCompound;
import org.bukkit.craftbukkit.v1_8_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R1.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class CustomNBT {
    public static MapOfEnchantments getEnchantments(ItemStack item) {
        return new MapOfEnchantments(item);
    }

    public static boolean hasCustomNBT(ItemStack item, String key) {
        if (item == null) {
            return false;
        }
        net.minecraft.server.v1_8_R1.ItemStack cis = CraftItemStack.asNMSCopy((ItemStack)item);
        if (!cis.hasTag()) {
            return false;
        }
        NBTTagCompound tag = cis.getTag();
        return tag.hasKey(key);
    }

    public static String getCustomNBT(ItemStack item, String key) {
        NBTTagCompound tag;
        if (item == null) {
            return null;
        }
        net.minecraft.server.v1_8_R1.ItemStack cis = CraftItemStack.asNMSCopy((ItemStack)item);
        if (!cis.hasTag()) {
            cis.setTag(new NBTTagCompound());
        }
        if ((tag = cis.getTag()).hasKey(key)) {
            return tag.getString(key);
        }
        return null;
    }

    public static ItemStack removeCustomNBT(ItemStack item, String key) {
        if (item == null) {
            return null;
        }
        net.minecraft.server.v1_8_R1.ItemStack cis = CraftItemStack.asNMSCopy((ItemStack)item);
        if (!cis.hasTag()) {
            cis.setTag(new NBTTagCompound());
        }
        NBTTagCompound tag = cis.getTag();
        tag.remove(key);
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_8_R1.ItemStack)cis);
    }

    public static ItemStack addCustomNBT(ItemStack item, String key, String value) {
        if (item == null) {
            return null;
        }
        net.minecraft.server.v1_8_R1.ItemStack cis = CraftItemStack.asNMSCopy((ItemStack)item);
        NBTTagCompound tag = null;
        if (!cis.hasTag()) {
            cis.setTag(new NBTTagCompound());
        }
        tag = cis.getTag();
        tag.setString(key, value);
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_8_R1.ItemStack)cis);
    }

    public static LivingEntity addCustomNBT(LivingEntity entity, String key, String value) {
        if (entity == null) {
            return null;
        }
        LivingEntity bukkitEntity = entity;
        Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
        NBTTagCompound tag = new NBTTagCompound();
        nmsEntity.c(tag);
        tag.setString(key, value);
        ((EntityLiving)nmsEntity).a(tag);
        return entity;
    }

    public static LivingEntity removeCustomNBT(LivingEntity entity, String key) {
        if (entity == null) {
            return null;
        }
        LivingEntity bukkitEntity = entity;
        Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
        NBTTagCompound tag = new NBTTagCompound();
        nmsEntity.c(tag);
        tag.remove(key);
        ((EntityLiving)nmsEntity).a(tag);
        return entity;
    }

    public static boolean hasCustomNBT(LivingEntity entity, String key) {
        if (entity == null) {
            return false;
        }
        LivingEntity bukkitEntity = entity;
        Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
        NBTTagCompound tag = new NBTTagCompound();
        nmsEntity.c(tag);
        return tag.hasKey(key);
    }

    public static String getCustomNBT(LivingEntity entity, String key) {
        if (entity == null) {
            return null;
        }
        LivingEntity bukkitEntity = entity;
        Entity nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
        NBTTagCompound tag = new NBTTagCompound();
        nmsEntity.c(tag);
        return tag.getString(key);
    }
}

