/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class aH {
    static final Pattern floatPrimitive = Pattern.compile("^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$");
    static final Pattern doublePrimitive = Pattern.compile("-?(?:\\d+)?(\\.\\d+)?");
    static final Pattern percentagePrimitive = Pattern.compile("-?(?:\\d+)?(\\.\\d+)?(%)?");
    static final Pattern integerPrimitive = Pattern.compile("(-)?\\d+");
    static final Pattern booleanPrimitive = Pattern.compile("true|false", 2);
    static final Pattern wordPrimitive = Pattern.compile("\\w+");
    private static final Pattern argsRegex = Pattern.compile("[^\\s\"'\u00a8]+|\"([^\"]*)\"|'([^']*)'|\u00a8([^\u00a8]*)\u00a8");
    static final Pattern matchesScriptPtrn = Pattern.compile("script:(.+)", 2);

    public static List<Argument> interpret(List<String> args) {
        ArrayList<Argument> arg_list = new ArrayList<Argument>();
        for (String string : args) {
            arg_list.add(new Argument(string.trim()));
        }
        return arg_list;
    }

    public static String[] buildArgs(String stringArgs) {
        if (stringArgs == null) {
            return null;
        }
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher regexMatcher = argsRegex.matcher(stringArgs);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                matchList.add(regexMatcher.group(1));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                matchList.add(regexMatcher.group(2));
                continue;
            }
            matchList.add(regexMatcher.group());
        }
        if (dB.showScriptBuilder) {
            dB.log("Constructed args: " + Arrays.toString(matchList.toArray()));
        }
        return matchList.toArray(new String[matchList.size()]);
    }

    public static String debugObj(String prefix, Object value) {
        return "<G>" + prefix + "='<Y>" + (value != null ? value.toString() : "null") + "<G>'  ";
    }

    public static <T extends dObject> String debugList(String prefix, Collection<T> objects) {
        if (objects == null) {
            return aH.debugObj(prefix, null);
        }
        StringBuilder sb = new StringBuilder();
        for (dObject obj : objects) {
            String output = obj.debug();
            sb.append(output.substring((obj.getPrefix() + "='<A>").length(), output.length() - 6)).append(", ");
        }
        if (sb.length() == 0) {
            return aH.debugObj(prefix, sb);
        }
        return aH.debugObj(prefix, "[" + sb.substring(0, sb.length() - 2) + "]");
    }

    public static String debugUniqueObj(String prefix, String id, Object value) {
        return "<G>" + prefix + "='<A>" + id + "<Y>(" + (value != null ? value.toString() : "null") + ")<G>'  ";
    }

    public static boolean matchesArg(String names, String string_arg) {
        String[] parts = names.split(",");
        if (parts.length == 1) {
            if (string_arg.toUpperCase().equals(names.toUpperCase())) {
                return true;
            }
        } else {
            for (String string : parts) {
                if (!string_arg.split(":")[0].equalsIgnoreCase(string.trim())) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean matchesValueArg(String names, String string_arg, ArgumentType type) {
        if (string_arg == null) {
            return false;
        }
        int firstColonIndex = string_arg.indexOf(58);
        if (firstColonIndex == -1) {
            return false;
        }
        String[] commaParts = names.split(",");
        if (commaParts.length == 1) {
            if (!string_arg.substring(0, firstColonIndex).equalsIgnoreCase(names)) {
                return false;
            }
        } else {
            boolean matched = false;
            for (String string : commaParts) {
                if (!string_arg.substring(0, firstColonIndex).equalsIgnoreCase(string.trim())) continue;
                matched = true;
            }
            if (!matched) {
                return false;
            }
        }
        string_arg = string_arg.split(":", 2)[1];
        switch (type) {
            case Word: {
                return wordPrimitive.matcher(string_arg).matches();
            }
            case Integer: {
                return integerPrimitive.matcher(string_arg).matches();
            }
            case Double: {
                return doublePrimitive.matcher(string_arg).matches();
            }
            case Float: {
                return floatPrimitive.matcher(string_arg).matches();
            }
            case Boolean: {
                return booleanPrimitive.matcher(string_arg).matches();
            }
            case Script: {
                return true;
            }
            case String: {
                return true;
            }
            case Custom: {
                return true;
            }
        }
        dB.echoError("Invalid or temporarily unavailable matches value!");
        dB.echoError("While parsing '" + string_arg + "', Denizen has run into a problem. While the " + "prefix is correct, the value is not valid. Check documentation for valid value." + "Perhaps a replaceable tag has failed to fill in a value?");
        return false;
    }

    public static boolean getBooleanFrom(String arg) {
        return Boolean.valueOf(aH.getStringFrom(arg));
    }

    public static double getDoubleFrom(String arg) {
        try {
            return Double.valueOf(aH.getStringFrom(arg));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static float getFloatFrom(String arg) {
        try {
            return Float.valueOf(aH.getStringFrom(arg)).floatValue();
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static int getIntegerFrom(String arg) {
        try {
            return Integer.valueOf(aH.getStringFrom(arg));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Deprecated
    public static dList getListFrom(String arg) {
        return dList.valueOf(aH.getStringFrom(arg));
    }

    public static long getLongFrom(String arg) {
        try {
            return Long.valueOf(aH.getStringFrom(arg));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Deprecated
    public static dScript getScriptFrom(String arg) {
        arg = arg.toLowerCase().replace("script:", "");
        return dScript.valueOf(arg);
    }

    public static String getStringFrom(String arg) {
        String[] parts = arg.split(":", 2);
        return parts.length >= 2 ? parts[1] : arg;
    }

    @Deprecated
    public static Duration getDurationFrom(String arg) {
        arg = arg.toLowerCase().replace("duration:", "").replace("delay:", "");
        return Duration.valueOf(arg);
    }

    public static boolean matchesDouble(String arg) {
        return doublePrimitive.matcher(arg).matches();
    }

    @Deprecated
    public static boolean matchesDuration(String arg) {
        arg = arg.toLowerCase().replace("duration:", "").replace("delay:", "");
        return Duration.matches(arg);
    }

    public static boolean matchesInteger(String arg) {
        return integerPrimitive.matcher(arg).matches();
    }

    @Deprecated
    public static boolean matchesItem(String arg) {
        return arg.length() > 5 && arg.toUpperCase().startsWith("ITEM:");
    }

    @Deprecated
    public static boolean matchesContext(String arg) {
        return arg.toUpperCase().startsWith("CONTEXT:") || arg.toUpperCase().startsWith("DEFINE:");
    }

    @Deprecated
    public static Map<String, String> getContextFrom(String arg) {
        HashMap<String, String> context = new HashMap<String, String>();
        int x = 1;
        for (String ctxt : aH.getListFrom(arg)) {
            context.put(String.valueOf(x), ctxt.trim());
            ++x;
        }
        return context;
    }

    @Deprecated
    public static boolean matchesLocation(String arg) {
        return arg.toUpperCase().startsWith("LOCATION:");
    }

    @Deprecated
    public static boolean matchesQuantity(String arg) {
        return arg.toUpperCase().startsWith("QTY:");
    }

    @Deprecated
    public static boolean matchesQueue(String arg) {
        return arg.toUpperCase().startsWith("QUEUE:");
    }

    @Deprecated
    public static boolean matchesScript(String arg) {
        Matcher m = matchesScriptPtrn.matcher(arg);
        if (m.matches()) {
            if (ScriptRegistry.containsScript(m.group(1))) {
                return true;
            }
            dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. This " + "argument's format is correct, but Denizen couldn't locate a script " + "named '" + m.group(1) + "'. Is it spelled correctly?");
        }
        return false;
    }

    @Deprecated
    public static boolean matchesState(String arg) {
        Pattern m = Pattern.compile("(state|toggle):(true|false|toggle)");
        if (m.matcher(arg).matches()) {
            return true;
        }
        if (arg.toUpperCase().startsWith("(state|toggle):")) {
            dB.echoError("While parsing '" + arg + "', Denizen has run into a problem. While the prefix is " + "correct, the value is not valid. 'STATE' requires a value of TRUE, FALSE, or TOGGLE. ");
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArgumentType {
        LivingEntity,
        Item,
        Boolean,
        Custom,
        Double,
        Float,
        Integer,
        String,
        Word,
        Location,
        Script,
        Duration;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Argument {
        public String raw_value;
        String prefix = null;
        String lower_prefix = null;
        String value;
        String lower_value;
        boolean has_prefix = false;

        public Argument(String string) {
            this.raw_value = string;
            string = string.trim();
            int first_colon = string.indexOf(58);
            int first_space = string.indexOf(32);
            if (first_space > -1 && first_space < first_colon || first_colon == -1) {
                this.value = string;
                this.lower_value = CoreUtilities.toLowerCase(string);
            } else {
                this.has_prefix = true;
                List<String> split = CoreUtilities.split(string, ':', 2);
                this.prefix = split.get(0);
                this.lower_prefix = CoreUtilities.toLowerCase(this.prefix);
                this.value = split.size() == 2 ? split.get(1) : "";
                this.lower_value = CoreUtilities.toLowerCase(this.value);
            }
        }

        public static Argument valueOf(String string) {
            return new Argument(string);
        }

        public boolean startsWith(String string) {
            return this.lower_value.startsWith(CoreUtilities.toLowerCase(string));
        }

        public boolean hasPrefix() {
            return this.has_prefix;
        }

        public Argument getPrefix() {
            if (this.prefix == null) {
                return null;
            }
            return Argument.valueOf(this.prefix);
        }

        public boolean matches(String values) {
            for (String value : CoreUtilities.split(values, ',')) {
                if (!CoreUtilities.toLowerCase(value.trim()).equals(this.lower_value)) continue;
                return true;
            }
            return false;
        }

        public boolean matches(String ... values) {
            for (String value : values) {
                if (!CoreUtilities.toLowerCase(value).equals(this.lower_value)) continue;
                return true;
            }
            return false;
        }

        public void replaceValue(String string) {
            this.value = string;
            this.lower_value = CoreUtilities.toLowerCase(this.value);
        }

        public String getValue() {
            return this.value;
        }

        public boolean matchesEnum(Enum<?>[] values) {
            for (Enum<?> value : values) {
                if (!value.name().replace("_", "").equalsIgnoreCase(this.value.replace("_", ""))) continue;
                return true;
            }
            return false;
        }

        public boolean matchesEnumList(Enum<?>[] values) {
            dList list = dList.valueOf(this.value);
            for (String string : list) {
                for (Enum<?> value : values) {
                    if (!value.name().replace("_", "").equalsIgnoreCase(string.replace("_", ""))) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean matchesPrefix(String values) {
            if (!this.hasPrefix()) {
                return false;
            }
            for (String value : CoreUtilities.split(values, ',')) {
                if (!CoreUtilities.toLowerCase(value.trim()).equals(this.lower_prefix)) continue;
                return true;
            }
            return false;
        }

        public boolean matchesPrefix(String ... values) {
            if (!this.hasPrefix()) {
                return false;
            }
            for (String value : values) {
                if (!CoreUtilities.toLowerCase(value).equals(this.lower_prefix)) continue;
                return true;
            }
            return false;
        }

        public boolean matchesPrimitive(PrimitiveType argumentType) {
            if (this.value == null) {
                return false;
            }
            switch (argumentType) {
                case Word: {
                    return wordPrimitive.matcher(this.value).matches();
                }
                case Integer: {
                    return integerPrimitive.matcher(this.value).matches();
                }
                case Double: {
                    return doublePrimitive.matcher(this.value).matches();
                }
                case Float: {
                    return floatPrimitive.matcher(this.value).matches();
                }
                case Boolean: {
                    return booleanPrimitive.matcher(this.value).matches();
                }
                case Percentage: {
                    return percentagePrimitive.matcher(this.value).matches();
                }
                case String: {
                    return true;
                }
            }
            return false;
        }

        public boolean matchesArgumentType(Class<? extends dObject> dClass) {
            return ObjectFetcher.checkMatch(dClass, this.value);
        }

        public boolean matchesArgumentTypes(Class<? extends dObject> ... dClasses) {
            for (Class<? extends dObject> c : dClasses) {
                if (!this.matchesArgumentType(c)) continue;
                return true;
            }
            return false;
        }

        public boolean matchesArgumentList(Class<? extends dObject> dClass) {
            dList list = dList.valueOf(this.value);
            return list.isEmpty() || list.containsObjectsFrom(dClass);
        }

        public Element asElement() {
            return new Element(this.prefix, this.value);
        }

        public <T extends dObject> T asType(Class<T> clazz) {
            T arg = ObjectFetcher.getObjectFrom(clazz, this.value);
            if (arg != null) {
                arg.setPrefix(this.prefix);
                return (T)((dObject)clazz.cast(arg));
            }
            return null;
        }

        public void reportUnhandled() {
            dB.echoError('\'' + this.raw_value + "' is an unknown argument!");
        }

        public String toString() {
            return this.raw_value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrimitiveType {
        Float,
        Double,
        Integer,
        Boolean,
        String,
        Word,
        Percentage;

    }
}

