/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.aufdemrand.denizencore.exceptions.ScriptEntryCreationException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.dB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BracedCommand
extends AbstractCommand {
    public static final boolean hyperdebug = false;

    public static LinkedHashMap<String, ArrayList<ScriptEntry>> getBracedCommands(ScriptEntry scriptEntry) {
        aH.Argument arg;
        int i;
        LinkedHashMap<String, ArrayList<ScriptEntry>> bracedSections = new LinkedHashMap<String, ArrayList<ScriptEntry>>();
        LinkedHashMap<String, ArrayList<ScriptEntry>> entryBracedSet = scriptEntry.getBracedSet();
        if (entryBracedSet != null) {
            try {
                for (Map.Entry<String, ArrayList<ScriptEntry>> entry : entryBracedSet.entrySet()) {
                    ArrayList<ScriptEntry> array = new ArrayList<ScriptEntry>(entry.getValue().size());
                    for (ScriptEntry sEntry : entry.getValue()) {
                        ScriptEntry newEntry = sEntry.clone();
                        newEntry.entryData.transferDataFrom(scriptEntry.entryData);
                        array.add(newEntry);
                    }
                    bracedSections.put(entry.getKey(), array);
                }
                return bracedSections;
            }
            catch (CloneNotSupportedException e) {
                dB.echoError(scriptEntry.getResidingQueue(), e);
            }
        }
        TreeMap commandList = new TreeMap();
        int bracesEntered = 0;
        boolean newCommand = true;
        boolean waitingForDash = false;
        ScriptEntry entry = scriptEntry;
        List<aH.Argument> argList = aH.interpret(entry.getArguments());
        String bracesName = scriptEntry.getCommandName();
        int startArg = 0;
        for (i = 0; i < argList.size(); ++i) {
            arg = argList.get(i);
            if (!arg.asElement().asString().equals("{")) continue;
            startArg = i;
            break;
        }
        for (i = startArg; i < argList.size(); ++i) {
            arg = argList.get(i);
            if (arg.matches("{")) {
                newCommand = false;
                boolean bl = waitingForDash = ++bracesEntered == 1;
                if (bracesEntered <= 1) continue;
                ((ArrayList)commandList.get(commandList.lastKey())).add(arg.raw_value);
                continue;
            }
            if (arg.matches("}")) {
                newCommand = false;
                if (--bracesEntered > 0) {
                    ((ArrayList)commandList.get(commandList.lastKey())).add(arg.raw_value);
                    continue;
                }
                if (bracedSections.containsKey(bracesName)) {
                    dB.echoError(scriptEntry.getResidingQueue(), "You may not have braced commands with the same arguments.");
                    break;
                }
                ArrayList<ScriptEntry> bracesSection = new ArrayList<ScriptEntry>();
                for (ArrayList command : commandList.values()) {
                    try {
                        if (command.isEmpty()) continue;
                        String cmd = (String)command.get(0);
                        command.remove(0);
                        String[] args = new String[command.size()];
                        args = command.toArray(args);
                        bracesSection.add(new ScriptEntry(cmd, args, scriptEntry.getScript() != null ? scriptEntry.getScript().getContainer() : null));
                        ((ScriptEntry)bracesSection.get((int)(bracesSection.size() - 1))).entryData.transferDataFrom(scriptEntry.entryData);
                    }
                    catch (ScriptEntryCreationException e) {}
                }
                bracedSections.put(bracesName.toUpperCase(), bracesSection);
                bracesName = "";
                continue;
            }
            if (newCommand && bracesEntered == 1) {
                commandList.put(commandList.size(), new ArrayList());
                ((ArrayList)commandList.get(commandList.lastKey())).add(arg.raw_value);
                newCommand = false;
                continue;
            }
            if (arg.matches("-") && bracesEntered == 1) {
                newCommand = true;
                waitingForDash = false;
                continue;
            }
            if (bracesEntered == 0) {
                bracesName = bracesName + arg.raw_value;
                continue;
            }
            if (waitingForDash) {
                dB.echoError(scriptEntry.getResidingQueue(), "Malformed braced section! Missing a - symbol!");
                break;
            }
            newCommand = false;
            ((ArrayList)commandList.get(commandList.lastKey())).add(arg.raw_value);
        }
        scriptEntry.setBracedSet(bracedSections);
        return bracedSections;
    }
}

