/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.containers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptBuilder;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.ScriptEntrySet;
import net.aufdemrand.denizencore.scripts.ScriptHelper;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptContainer
implements Debuggable {
    YamlConfiguration contents;
    private String name;
    private Map<String, ScriptEntrySet> scriptsMap = new HashMap<String, ScriptEntrySet>();
    private Boolean shouldDebug = null;

    public ScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        this.contents = configurationSection;
        this.name = scriptContainerName.toUpperCase();
    }

    public YamlConfiguration getContents() {
        return this.contents;
    }

    public <T extends ScriptContainer> T getAsContainerType(Class<T> type) {
        return (T)((ScriptContainer)type.cast(this));
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return ScriptHelper.getSource(this.getName());
    }

    public String getOriginalName() {
        return ScriptHelper.getOriginalName(this.getName());
    }

    public dScript getAsScriptArg() {
        return dScript.valueOf(this.name);
    }

    public String getContainerType() {
        return this.contents.contains("TYPE") ? this.contents.getString("TYPE").toUpperCase() : null;
    }

    public boolean contains(String path) {
        return this.contents.contains(path.toUpperCase());
    }

    public String getString(String path) {
        return this.contents.getString(path.toUpperCase());
    }

    public String getString(String path, String def) {
        return this.contents.getString(path.toUpperCase(), def);
    }

    public List<String> getStringList(String path) {
        return this.contents.getStringList(path.toUpperCase());
    }

    public YamlConfiguration getConfigurationSection(String path) {
        if (path.length() == 0) {
            return this.contents;
        }
        return this.contents.getConfigurationSection(path.toUpperCase());
    }

    public void set(String path, Object object) {
        this.contents.set(path.toUpperCase(), object);
    }

    public List<ScriptEntry> getBaseEntries(ScriptEntryData data) {
        return this.getEntries(data, "script");
    }

    public List<ScriptEntry> getEntries(ScriptEntryData data, String path) {
        ScriptEntrySet set;
        if (path == null) {
            path = "script";
        }
        if ((set = this.getSetFor(path.toUpperCase())) == null) {
            return new ArrayList<ScriptEntry>();
        }
        for (ScriptEntry entry : set.getEntries()) {
            entry.entryData = data.clone();
        }
        return set.getEntries();
    }

    ScriptEntrySet getSetFor(String path) {
        ScriptEntrySet got = this.scriptsMap.get(path);
        if (got != null) {
            return got.Duplicate();
        }
        List<String> stringEntries = this.contents.getStringList(path);
        if (stringEntries == null || stringEntries.size() == 0) {
            return null;
        }
        List<ScriptEntry> entries = ScriptBuilder.buildScriptEntries(stringEntries, this, null);
        got = new ScriptEntrySet(entries);
        this.scriptsMap.put(path, got);
        return got.Duplicate();
    }

    @Override
    public boolean shouldDebug() {
        if (this.shouldDebug == null) {
            this.shouldDebug = !this.contents.contains("DEBUG") || !this.contents.getString("DEBUG").equalsIgnoreCase("false");
        }
        return this.shouldDebug;
    }

    @Override
    public boolean shouldFilter(String criteria) throws Exception {
        return this.name.equalsIgnoreCase(criteria.replace("s@", ""));
    }

    public String toString() {
        return "s@" + CoreUtilities.toLowerCase(this.getName());
    }
}

