/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.containers.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.scripts.ScriptBuilder;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizencore.scripts.queues.core.TimedQueue;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskScriptContainer
extends ScriptContainer {
    public TaskScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
    }

    public Duration getSpeed() {
        Duration speed = this.contains("SPEED") ? (this.getString("SPEED", "0").toUpperCase().equals("INSTANT") ? Duration.valueOf("0t") : Duration.valueOf(this.getString("SPEED", "0t"))) : new Duration(Duration.valueOf(DenizenCore.getImplementation().scriptQueueSpeed()).getSeconds());
        return speed;
    }

    public TaskScriptContainer setSpeed(Duration speed) {
        this.set("SPEED", speed.getSeconds());
        return this;
    }

    public ScriptQueue runTaskScript(ScriptEntryData data, Map<String, String> context) {
        return this.runTaskScript(ScriptQueue.getNextId(this.getName()), data, context);
    }

    public ScriptQueue runTaskScript(String queueId, ScriptEntryData data, Map<String, String> context) {
        ScriptQueue queue = this.getSpeed().getSeconds() == 0.0 ? InstantQueue.getQueue(queueId) : TimedQueue.getQueue(queueId).setSpeed(this.getSpeed().getTicks());
        List<ScriptEntry> listOfEntries = this.getBaseEntries(data);
        if (context != null) {
            ScriptBuilder.addObjectToEntries(listOfEntries, "context", context);
        }
        queue.addEntries(listOfEntries);
        queue.start();
        return queue;
    }

    public Map<String, Integer> getContextMap() {
        if (this.contains("CONTEXT")) {
            HashMap<String, Integer> context = new HashMap<String, Integer>();
            int x = 1;
            for (String name : this.getString("CONTEXT").split("\\|")) {
                context.put(name.toUpperCase(), x);
                ++x;
            }
            return context;
        }
        return Collections.emptyMap();
    }

    public ScriptQueue runTaskScriptWithDelay(String queueId, ScriptEntryData data, Map<String, String> context, Duration delay) {
        ScriptQueue queue = this.getSpeed().getSeconds() == 0.0 ? InstantQueue.getQueue(queueId) : TimedQueue.getQueue(queueId).setSpeed(this.getSpeed().getTicks());
        List<ScriptEntry> listOfEntries = this.getBaseEntries(data);
        if (context != null) {
            ScriptBuilder.addObjectToEntries(listOfEntries, "context", context);
        }
        queue.addEntries(listOfEntries);
        queue.delayUntil(System.currentTimeMillis() + (long)(delay.getSeconds() * 1000.0));
        queue.start();
        return queue;
    }

    public ScriptQueue injectTaskScript(String queueId, ScriptEntryData data, Map<String, String> context) {
        ScriptQueue queue = ScriptQueue._getExistingQueue(queueId);
        List<ScriptEntry> listOfEntries = this.getBaseEntries(data);
        if (context != null) {
            ScriptBuilder.addObjectToEntries(listOfEntries, "context", context);
        }
        queue.injectEntries(listOfEntries, 0);
        queue.start();
        return queue;
    }
}

