/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.tags;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.tags.core.ContextTags;
import net.aufdemrand.denizencore.tags.core.DefinitionTags;
import net.aufdemrand.denizencore.tags.core.EscapeTags;
import net.aufdemrand.denizencore.tags.core.ListTags;
import net.aufdemrand.denizencore.tags.core.ProcedureScriptTags;
import net.aufdemrand.denizencore.tags.core.QueueTags;
import net.aufdemrand.denizencore.tags.core.ScriptTags;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagManager {
    private static List<Method> methods = new ArrayList<Method>();
    private static List<Object> method_objects = new ArrayList<Object>();

    public void registerCoreTags() {
        new ListTags();
        new QueueTags();
        new ScriptTags();
        new ProcedureScriptTags();
        new ContextTags();
        new EscapeTags();
        new DefinitionTags();
        TagManager.registerTagEvents(this);
    }

    public static void registerTagEvents(Object o) {
        for (Method method : o.getClass().getMethods()) {
            if (!method.isAnnotationPresent(TagEvents.class)) continue;
            Class<?>[] parameters = method.getParameterTypes();
            if (parameters.length != 1 || parameters[0] != ReplaceableTagEvent.class) {
                dB.echoError("Class " + o.getClass().getCanonicalName() + " has a method " + method.getName() + " that is targeted at the event manager but has invalid parameters.");
                break;
            }
            TagManager.registerMethod(method, o);
        }
    }

    public static void unregisterTagEvents(Object o) {
        for (int i = 0; i < methods.size(); ++i) {
            if (method_objects.get(i) != o) continue;
            methods.remove(i);
            method_objects.remove(i);
            --i;
        }
    }

    public static void registerMethod(Method method, Object o) {
        methods.add(method);
        method_objects.add(o);
    }

    public static void fireEvent(ReplaceableTagEvent event) {
        for (int i = 0; i < methods.size(); ++i) {
            try {
                methods.get(i).invoke(method_objects.get(i), event);
                continue;
            }
            catch (Exception ex) {
                dB.echoError(ex);
            }
        }
    }

    public static String cleanOutput(String input) {
        if (input == null) {
            return null;
        }
        char[] data = input.toCharArray();
        block7: for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case '\u0001': {
                    data[i] = 60;
                    continue block7;
                }
                case '\u0002': {
                    data[i] = 62;
                    continue block7;
                }
                case '\u0007': {
                    data[i] = 91;
                    continue block7;
                }
                case '\t': {
                    data[i] = 93;
                    continue block7;
                }
                case '\u0005': {
                    data[i] = 124;
                    continue block7;
                }
            }
        }
        return new String(data);
    }

    public static String cleanOutputFully(String input) {
        if (input == null) {
            return null;
        }
        char[] data = input.toCharArray();
        block9: for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case '\u0001': {
                    data[i] = 60;
                    continue block9;
                }
                case '\u0002': {
                    data[i] = 62;
                    continue block9;
                }
                case '\u2011': {
                    data[i] = 59;
                    continue block9;
                }
                case '\u00a0': {
                    data[i] = 32;
                    continue block9;
                }
                case '\u0007': {
                    data[i] = 91;
                    continue block9;
                }
                case '\t': {
                    data[i] = 93;
                    continue block9;
                }
                case '\u0005': {
                    data[i] = 124;
                    continue block9;
                }
            }
        }
        return new String(data);
    }

    public static String escapeOutput(String input) {
        if (input == null) {
            return null;
        }
        char[] data = input.toCharArray();
        block7: for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case '<': {
                    data[i] = '\u0001';
                    continue block7;
                }
                case '>': {
                    data[i] = 2;
                    continue block7;
                }
                case '[': {
                    data[i] = 7;
                    continue block7;
                }
                case ']': {
                    data[i] = 9;
                    continue block7;
                }
                case '|': {
                    data[i] = 5;
                    continue block7;
                }
            }
        }
        return new String(data);
    }

    @TagEvents
    public void fetchObject(ReplaceableTagEvent event) {
        if (!event.getName().contains("@")) {
            return;
        }
        String object_type = CoreUtilities.toLowerCase(CoreUtilities.split(event.getName(), '@').get(0));
        Class object_class = ObjectFetcher.getObjectClass(object_type);
        if (object_class == null) {
            dB.echoError("Invalid object type! Could not fetch '" + object_type + "'!");
            event.setReplaced("null");
            return;
        }
        try {
            if (!ObjectFetcher.checkMatch(object_class, event.hasNameContext() ? event.getName() + '[' + event.getNameContext() + ']' : event.getName())) {
                dB.echoDebug((Debuggable)event.getScriptEntry(), "Returning null. '" + event.getName() + "' is an invalid " + object_class.getSimpleName() + ".");
                event.setReplaced("null");
                return;
            }
            Object arg = ObjectFetcher.getObjectFrom(object_class, event.hasNameContext() ? event.getName() + '[' + event.getNameContext() + ']' : event.getName());
            if (arg == null) {
                dB.echoError((event.hasNameContext() ? event.getName() + '[' + event.getNameContext() + ']' : event.getName()) + " is an invalid dObject!");
                return;
            }
            Attribute attribute = event.getAttributes();
            event.setReplaced(arg.getAttribute(attribute.fulfill(1)));
        }
        catch (Exception e) {
            dB.echoError("Uh oh! Report this to the Denizen developers! Err: TagManagerObjectReflection");
            dB.echoError(e);
        }
    }

    public static String readSingleTag(String str, TagContext context) {
        ReplaceableTagEvent event = new ReplaceableTagEvent(str, context);
        if (event.isInstant() != context.instant) {
            return String.valueOf('\u0001') + str + String.valueOf('\u0002');
        }
        TagManager.fireEvent(event);
        if (!event.replaced() && event.getAlternative() != null && event.hasAlternative()) {
            event.setReplaced(event.getAlternative());
        }
        if (context.debug) {
            dB.echoDebug((Debuggable)context.entry, "Filled tag <" + event.toString() + "> with '" + event.getReplaced() + "'.");
        }
        if (!event.replaced()) {
            dB.echoError(context.entry != null ? context.entry.getResidingQueue() : null, "Tag <" + event.toString() + "> is invalid!");
        }
        return TagManager.escapeOutput(event.getReplaced());
    }

    public static String tag(String arg, TagContext context) {
        String replaced;
        if (arg == null) {
            return null;
        }
        if (arg.indexOf(62) == -1 || arg.length() < 3) {
            return TagManager.cleanOutput(arg);
        }
        int[] positions = TagManager.locateTag(arg);
        if (positions == null) {
            return TagManager.cleanOutput(arg);
        }
        int failsafe = 0;
        do {
            ++failsafe;
            if (positions == null) break;
            String oriarg = arg.substring(positions[0] + 1, positions[1]);
            replaced = TagManager.readSingleTag(oriarg, context);
        } while ((positions = TagManager.locateTag(arg = arg.substring(0, positions[0]) + replaced + arg.substring(positions[1] + 1, arg.length()))) != null || failsafe < 50);
        return TagManager.cleanOutput(arg);
    }

    private static int[] locateTag(String arg) {
        int first = arg.indexOf(60);
        if (first == -1) {
            return null;
        }
        if (first + 1 < arg.length() && arg.charAt(first + 1) == '-') {
            return TagManager.locateTag(arg.substring(0, first) + '\u0001' + arg.substring(first + 1));
        }
        int len = arg.length();
        int bracks = 0;
        int second = -1;
        for (int i = first + 1; i < len; ++i) {
            if (arg.charAt(i) == '<') {
                ++bracks;
                continue;
            }
            if (arg.charAt(i) != '>' || --bracks != -1) continue;
            second = i;
            break;
        }
        if (first > -1 && second > first) {
            return new int[]{first, second};
        }
        return null;
    }

    public static List<String> fillArguments(List<String> args, TagContext context) {
        ArrayList<String> filledArgs = new ArrayList<String>();
        int nested_level = 0;
        if (args != null) {
            for (String argument : args) {
                if (argument.equals("{")) {
                    ++nested_level;
                }
                if (argument.equals("}")) {
                    --nested_level;
                }
                if (nested_level < 1) {
                    filledArgs.add(TagManager.tag(argument, context));
                    continue;
                }
                filledArgs.add(argument);
            }
        }
        return filledArgs;
    }

    public static List<String> fillArguments(String[] args, TagContext context) {
        ArrayList<String> filledArgs = new ArrayList<String>();
        if (args != null) {
            for (String argument : args) {
                filledArgs.add(TagManager.tag(argument, context));
            }
        }
        return filledArgs;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TagEvents {
    }
}

