/*
 * Decompiled with CFR 0.152.
 */
package org.shade.abstractmeta.toolbox.compilation.compiler.impl;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.shade.abstractmeta.toolbox.compilation.compiler.JavaSourceCompiler;
import org.shade.abstractmeta.toolbox.compilation.compiler.impl.JavaCodeFileObject;
import org.shade.abstractmeta.toolbox.compilation.compiler.impl.JavaSourceFileObject;
import org.shade.abstractmeta.toolbox.compilation.compiler.impl.SimpleClassLoader;
import org.shade.abstractmeta.toolbox.compilation.compiler.impl.SimpleJavaFileManager;
import org.shade.abstractmeta.toolbox.compilation.compiler.registry.JavaFileObjectRegistry;
import org.shade.abstractmeta.toolbox.compilation.compiler.registry.impl.JavaFileObjectRegistryImpl;
import org.shade.abstractmeta.toolbox.compilation.compiler.util.URIUtil;

public class JavaSourceCompilerImpl
implements JavaSourceCompiler {
    private final Logger logger = Logger.getLogger(JavaSourceCompilerImpl.class.getName());
    private static final List<String> CLASS_PATH_OPTIONS = new ArrayList<String>(Arrays.asList("cp", "classpath"));

    @Override
    public ClassLoader compile(JavaSourceCompiler.CompilationUnit compilationUnit, String ... options) {
        return this.compile(this.getClass().getClassLoader(), compilationUnit, options);
    }

    @Override
    public ClassLoader compile(ClassLoader parentClassLoader, JavaSourceCompiler.CompilationUnit compilationUnit, String ... options) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        return this.compile(compiler, parentClassLoader, compilationUnit, options);
    }

    protected ClassLoader compile(JavaCompiler compiler, ClassLoader parentClassLoader, JavaSourceCompiler.CompilationUnit compilationUnit, String ... options) {
        if (compiler == null) {
            throw new IllegalStateException("Failed to find the system Java compiler. Check that your class path includes tools.jar");
        }
        JavaFileObjectRegistry registry = compilationUnit.getRegistry();
        SimpleClassLoader result = new SimpleClassLoader(parentClassLoader, registry, compilationUnit.getOutputClassDirectory());
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(diagnostics, null, null);
        SimpleJavaFileManager javaFileManager = new SimpleJavaFileManager(standardFileManager, result, registry);
        Collection<JavaFileObject> sources = registry.get(JavaFileObject.Kind.SOURCE);
        Collection<String> compilationOptions = this.buildOptions(compilationUnit, result, options);
        JavaCompiler.CompilationTask task = compiler.getTask(null, javaFileManager, diagnostics, compilationOptions, null, sources);
        StringBuilder diagnosticBuilder = new StringBuilder();
        task.call();
        boolean compilationError = false;
        for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
            compilationError |= this.buildDiagnosticMessage(diagnostic, diagnosticBuilder, registry);
        }
        if (diagnosticBuilder.length() > 0) {
            if (compilationError) {
                throw new IllegalStateException(diagnosticBuilder.toString());
            }
            this.logger.log(Level.WARNING, diagnosticBuilder.toString());
        }
        result.addClassPathEntries(compilationUnit.getClassPathsEntries());
        return result;
    }

    protected boolean buildDiagnosticMessage(Diagnostic diagnostic, StringBuilder diagnosticBuilder, JavaFileObjectRegistry registry) {
        Object source = diagnostic.getSource();
        String sourceErrorDetails = "";
        if (source != null) {
            JavaSourceFileObject sourceFile = (JavaSourceFileObject)JavaSourceFileObject.class.cast(source);
            CharSequence sourceCode = sourceFile.getCharContent(true);
            int startPosition = Math.max((int)diagnostic.getStartPosition() - 10, 0);
            int endPosition = Math.min(sourceCode.length(), (int)diagnostic.getEndPosition() + 10);
            sourceErrorDetails = sourceCode.subSequence(startPosition, endPosition) + "";
        }
        diagnosticBuilder.append(diagnostic.getMessage(null));
        diagnosticBuilder.append("\n");
        diagnosticBuilder.append(sourceErrorDetails);
        return diagnostic.getKind().equals((Object)Diagnostic.Kind.ERROR);
    }

    protected Collection<String> buildOptions(JavaSourceCompiler.CompilationUnit compilationUnit, SimpleClassLoader classLoader, String ... options) {
        ArrayList<String> result = new ArrayList<String>();
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        for (int i = 0; i < options.length; i += 2) {
            optionsMap.put(options[i], options[i + 1]);
        }
        for (String classPathKey : CLASS_PATH_OPTIONS) {
            if (!optionsMap.containsKey(classPathKey)) continue;
            this.addClassPath(compilationUnit, (String)optionsMap.get(classPathKey));
        }
        for (String key : optionsMap.keySet()) {
            if (CLASS_PATH_OPTIONS.contains(key)) continue;
            result.addAll(Arrays.asList(key, (String)optionsMap.get(key)));
        }
        this.addClassPath(result, compilationUnit);
        return result;
    }

    private void addClassPath(List<String> result, JavaSourceCompiler.CompilationUnit compilationUnit) {
        StringBuilder classPathBuilder = new StringBuilder();
        for (String entry : compilationUnit.getClassPathsEntries()) {
            if (classPathBuilder.length() > 0) {
                classPathBuilder.append(";");
            }
            classPathBuilder.append(entry);
        }
        if (classPathBuilder.length() > 0) {
            result.addAll(Arrays.asList("-cp", classPathBuilder.toString()));
        }
    }

    protected void addClassPath(JavaSourceCompiler.CompilationUnit result, String classPath) {
        String[] classPathEntries;
        for (String classPathEntry : classPathEntries = classPath.split(";")) {
            result.addClassPathEntry(classPathEntry);
        }
    }

    @Override
    public JavaSourceCompiler.CompilationUnit createCompilationUnit() {
        File outputDirectory = new File(System.getProperty("java.io.tmpdir"), "compiled-code");
        return this.createCompilationUnit(outputDirectory);
    }

    @Override
    public JavaSourceCompiler.CompilationUnit createCompilationUnit(File outputClassDirectory) {
        return new CompilationUnitImpl(outputClassDirectory);
    }

    @Override
    public void persistCompiledClasses(JavaSourceCompiler.CompilationUnit compilationUnit) {
        JavaFileObjectRegistry registry = compilationUnit.getRegistry();
        File classOutputDirectory = compilationUnit.getOutputClassDirectory();
        if (!classOutputDirectory.exists()) {
            return;
        }
        for (JavaFileObject javaFileObject : registry.get(JavaFileObject.Kind.CLASS)) {
            String internalName = javaFileObject.getName().substring(1);
            File compiledClassFile = new File(classOutputDirectory, internalName);
            if (!compiledClassFile.getParentFile().exists() && !compiledClassFile.getParentFile().mkdirs()) {
                throw new IllegalStateException("Failed to create directories " + compiledClassFile.getParent());
            }
            try {
                Files.write(((JavaCodeFileObject)JavaCodeFileObject.class.cast(javaFileObject)).getByteCode(), compiledClassFile);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to write to file " + compiledClassFile, e);
            }
        }
    }

    public static class CompilationUnitImpl
    implements JavaSourceCompiler.CompilationUnit {
        private final List<String> classPathEntries = new ArrayList<String>();
        private final JavaFileObjectRegistry registry = new JavaFileObjectRegistryImpl();
        private final File outputClassDirectory;

        public CompilationUnitImpl(File outputClassDirectory) {
            this.outputClassDirectory = outputClassDirectory;
        }

        @Override
        public void addClassPathEntry(String classPathEntry) {
            this.classPathEntries.add(classPathEntry);
        }

        @Override
        public void addClassPathEntries(Collection<String> classPathEntries) {
            this.classPathEntries.addAll(classPathEntries);
        }

        @Override
        public void addJavaSource(String className, String source) {
            URI sourceUri = URIUtil.buildUri(StandardLocation.SOURCE_OUTPUT, className);
            this.registry.register(new JavaSourceFileObject(sourceUri, source));
        }

        @Override
        public JavaFileObjectRegistry getRegistry() {
            return this.registry;
        }

        @Override
        public List<String> getClassPathsEntries() {
            return this.classPathEntries;
        }

        @Override
        public File getOutputClassDirectory() {
            return this.outputClassDirectory;
        }
    }
}

