/*
 * Decompiled with CFR 0.152.
 */
package org.shade.abstractmeta.toolbox.compilation.compiler.impl;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.shade.abstractmeta.toolbox.compilation.compiler.impl.JavaCodeFileObject;
import org.shade.abstractmeta.toolbox.compilation.compiler.registry.JavaFileObjectRegistry;
import org.shade.abstractmeta.toolbox.compilation.compiler.util.URIUtil;

public class SimpleClassLoader
extends ClassLoader {
    private final List<JarFile> jarFiles = new ArrayList<JarFile>();
    private final List<File> classDirectories = new ArrayList<File>();
    private final JavaFileObjectRegistry registry;
    private final File classOutputDirectory;

    public SimpleClassLoader(ClassLoader parentClassLoader, JavaFileObjectRegistry registry, File classOutputDirectory) {
        super(parentClassLoader);
        this.registry = registry;
        this.classOutputDirectory = classOutputDirectory;
    }

    public void addClassPathEntry(String classPathEntry) {
        if (classPathEntry.endsWith(".jar")) {
            try {
                JarFile jarFile = new JarFile(classPathEntry);
                this.jarFiles.add(jarFile);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to register classPath entry: " + classPathEntry, e);
            }
        } else {
            File classDirectory = new File(classPathEntry);
            this.classDirectories.add(classDirectory);
        }
    }

    public void addClassPathEntries(Iterable<String> classPathEntries) {
        for (String classPathEntry : classPathEntries) {
            this.addClassPathEntry(classPathEntry);
        }
    }

    @Override
    protected Class<?> findClass(String qualifiedClassName) throws ClassNotFoundException {
        URI classUri = URIUtil.buildUri(StandardLocation.CLASS_OUTPUT, qualifiedClassName);
        if (this.registry.isRegistered(classUri)) {
            JavaFileObject result = this.registry.get(classUri);
            byte[] byteCode = ((JavaCodeFileObject)JavaCodeFileObject.class.cast(result)).getByteCode();
            return this.defineClass(qualifiedClassName, byteCode, 0, byteCode.length);
        }
        Class<?> result = this.findClassInFileSystem(qualifiedClassName);
        if (result != null) {
            return result;
        }
        result = this.findClassInJarFile(qualifiedClassName);
        if (result != null) {
            return result;
        }
        try {
            result = Class.forName(qualifiedClassName);
            return result;
        }
        catch (ClassNotFoundException nf) {
            return super.findClass(qualifiedClassName);
        }
    }

    protected Class<?> findClassInFileSystem(String qualifiedClassName) {
        for (File classDirectory : this.classDirectories) {
            File classFile = new File(classDirectory, qualifiedClassName.replace('.', '/') + ".class");
            if (!classFile.exists()) continue;
            try {
                byte[] byteCode = Files.toByteArray(classFile);
                return this.defineClass(qualifiedClassName, byteCode, 0, byteCode.length);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read class file " + classFile, e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> findClassInJarFile(String qualifiedClassName) throws ClassNotFoundException {
        URI classUri = URIUtil.buildUri(StandardLocation.CLASS_OUTPUT, qualifiedClassName);
        String internalClassName = classUri.getPath().substring(1);
        JarFile jarFile = null;
        for (int i = 0; i < this.jarFiles.size(); ++i) {
            Class<?> clazz;
            jarFile = this.jarFiles.get(i);
            JarEntry jarEntry = jarFile.getJarEntry(internalClassName);
            if (jarEntry == null) continue;
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            try {
                byte[] byteCode = new byte[(int)jarEntry.getSize()];
                ByteStreams.read(inputStream, byteCode, 0, byteCode.length);
                clazz = this.defineClass(qualifiedClassName, byteCode, 0, byteCode.length);
            }
            catch (Throwable throwable) {
                try {
                    Closeables.closeQuietly((Closeable)inputStream);
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(String.format("Failed to lookup class %s in jar file %s", qualifiedClassName, jarFile), e);
                }
            }
            Closeables.closeQuietly((Closeable)inputStream);
            return clazz;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String resource) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>(Collections.list(super.findResources(resource)));
        this.findResourcesInJarFiles(result, resource);
        this.findResourcesInJavaFileObjectRegistry(result, resource);
        return Collections.enumeration(result);
    }

    protected void findResourcesInJarFiles(List<URL> result, String resource) throws MalformedURLException {
        for (JarFile jarFile : this.jarFiles) {
            JarEntry entry = jarFile.getJarEntry(resource);
            if (entry == null) continue;
            result.add(new URL("jar", "", String.format("file:%s!%s", jarFile.getName(), resource)));
        }
    }

    protected void findResourcesInJavaFileObjectRegistry(List<URL> result, String resource) throws MalformedURLException {
        for (JavaFileObject javaFileObject : this.registry.get(JavaFileObject.Kind.CLASS)) {
            String internalName = javaFileObject.getName().substring(1);
            if (!internalName.startsWith(resource)) continue;
            File file = new File(this.classOutputDirectory, internalName);
            result.add(new URL(String.format("file://%s", file.getAbsolutePath())));
        }
    }
}

