/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.block.Biome;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiomeEnterExitSmartEvent
implements OldSmartEvent,
Listener {
    ArrayList<String> cuboids_to_watch = new ArrayList();

    @Override
    public boolean shouldInitialize(Set<String> events) {
        for (String event : events) {
            Matcher m = Pattern.compile("on player (?:enters|exits) (biome|\\w+)", 2).matcher(event);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Biome Enter & Exit SmartEvent.");
    }

    @Override
    public void breakDown() {
        PlayerMoveEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void playerMoveEvent(PlayerMoveEvent event) {
        Biome to;
        if (event.getFrom().getBlock().equals(event.getTo().getBlock())) {
            return;
        }
        Biome from = event.getFrom().getWorld().getBiome(event.getFrom().getBlockX(), event.getFrom().getBlockZ());
        if (!from.equals((Object)(to = event.getTo().getWorld().getBiome(event.getTo().getBlockX(), event.getTo().getBlockZ())))) {
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            context.put("from", new dLocation(event.getFrom()));
            context.put("to", new dLocation(event.getFrom()));
            context.put("old_biome", new Element(from.name()));
            context.put("new_biome", new Element(to.name()));
            List<String> determinations = OldEventManager.doEvents(Arrays.asList("player enters biome", "player exits biome", "player enters " + to.name(), "player exits " + from.name()), new BukkitScriptEntryData(dEntity.getPlayerFrom((Entity)event.getPlayer()), null), context, true);
            for (String determination : determinations) {
                if (!determination.toUpperCase().startsWith("CANCELLED")) continue;
                event.setCancelled(true);
            }
        }
    }
}

