/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityDeathSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        for (String event : events) {
            Matcher m = Pattern.compile("on (e@)?\\w+ (death|dies)", 2).matcher(event);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Entity Death SmartEvent.");
    }

    @Override
    public void breakDown() {
        EntityDeathEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void entityDeath(EntityDeathEvent event) {
        dPlayer player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        context.put("entity", entity.getDenizenObject());
        if (event.getEntity().getLastDamageCause() != null) {
            context.put("cause", new Element(event.getEntity().getLastDamageCause().getCause().toString()));
        }
        dList drops_dlist = new dList();
        for (ItemStack stack : event.getDrops()) {
            if (stack == null) {
                drops_dlist.add("i@air");
                continue;
            }
            drops_dlist.add(new dItem(stack).identify());
        }
        context.put("drops", drops_dlist);
        if (entity.isCitizensNPC()) {
            npc = entity.getDenizenNPC();
        } else if (entity.isPlayer()) {
            player = entity.getDenizenPlayer();
        }
        EntityDamageEvent lastDamage = entity.getBukkitEntity().getLastDamageCause();
        if (lastDamage != null && lastDamage instanceof EntityDamageByEntityEvent) {
            context.put("damager", new dEntity(((EntityDamageByEntityEvent)lastDamage).getDamager()).getDenizenObject());
        }
        PlayerDeathEvent subEvent = null;
        if (event instanceof PlayerDeathEvent) {
            subEvent = (PlayerDeathEvent)event;
            context.put("message", new Element(subEvent.getDeathMessage()));
            if (player != null) {
                context.put("inventory", player.getInventory());
            }
        }
        List<String> determinations = OldEventManager.doEvents(Arrays.asList("entity dies", entity.identifyType() + " dies", entity.identifySimple() + " dies", entity.identifySimple() + " death", "entity death", entity.identifyType() + " death"), new BukkitScriptEntryData(player, npc), context, true);
        for (String determination : determinations) {
            if (determination.toUpperCase().startsWith("DROPS ")) {
                determination = determination.substring(6);
            }
            if (determination.toUpperCase().startsWith("NO_DROPS")) {
                event.getDrops().clear();
                if (!determination.endsWith("_OR_XP")) continue;
                event.setDroppedExp(0);
                continue;
            }
            if (determination.toUpperCase().equals("NO_XP")) {
                event.setDroppedExp(0);
                continue;
            }
            if (aH.Argument.valueOf(determination).matchesArgumentList(dItem.class)) {
                dList drops = dList.valueOf(determination);
                drops.filter(dItem.class);
                event.getDrops().clear();
                for (String drop : drops) {
                    dItem item = dItem.valueOf(drop);
                    if (item == null) continue;
                    event.getDrops().add(item.getItemStack());
                }
                continue;
            }
            if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Integer)) {
                int xp = Integer.valueOf(determination.substring(3));
                event.setDroppedExp(xp);
                continue;
            }
            if (determination.toUpperCase().equals("NONE") || !(event instanceof PlayerDeathEvent)) continue;
            subEvent.setDeathMessage(determination);
        }
    }
}

