/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitySpawnSmartEvent
implements OldSmartEvent,
Listener {
    @Override
    public boolean shouldInitialize(Set<String> events) {
        boolean should_register = false;
        for (String event : events) {
            Matcher m = Pattern.compile("on (\\w+) spawns(?: in (\\w+))?(?: because (\\w+))?", 2).matcher(event);
            if (!m.matches() || !dEntity.matches(m.group(1)) && !m.group(1).equalsIgnoreCase("entity") && !m.group(1).equalsIgnoreCase("npc")) continue;
            should_register = true;
        }
        return should_register;
    }

    @Override
    public void _initialize() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
        dB.log("Loaded Entity Spawn SmartEvent.");
    }

    @Override
    public void breakDown() {
        CreatureSpawnEvent.getHandlerList().unregister((Listener)this);
    }

    @EventHandler
    public void npcSpawn(NPCSpawnEvent event) {
        if (event.getNPC().getEntity() instanceof LivingEntity) {
            this.creatureSpawn(new CreatureSpawnEvent((LivingEntity)event.getNPC().getEntity(), CreatureSpawnEvent.SpawnReason.CUSTOM));
        }
    }

    @EventHandler
    public void creatureSpawn(CreatureSpawnEvent event) {
        ArrayList<String> events = new ArrayList<String>();
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity((Entity)event.getEntity());
        String reason = event.getSpawnReason().name();
        List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(event.getLocation());
        dList cuboid_context = new dList();
        for (dCuboid cuboid : cuboids) {
            events.add("entity spawns in " + cuboid.identifySimple());
            events.add("entity spawns in " + cuboid.identifySimple() + " because " + reason);
            events.add(entity.identifyType() + " spawns in " + cuboid.identifySimple());
            events.add(entity.identifyType() + " spawns in " + cuboid.identifySimple() + " because " + reason);
            events.add(entity.identifySimple() + " spawns in " + cuboid.identifySimple());
            events.add(entity.identifySimple() + " spawns in " + cuboid.identifySimple() + " because " + reason);
            cuboid_context.add(cuboid.identify());
        }
        context.put("cuboids", cuboid_context);
        events.add("entity spawns");
        events.add("entity spawns because " + reason);
        events.add(entity.identifyType() + " spawns");
        events.add(entity.identifyType() + " spawns because " + reason);
        events.add(entity.identifySimple() + " spawns");
        events.add(entity.identifySimple() + " spawns because " + reason);
        context.put("entity", entity);
        context.put("reason", new Element(reason));
        context.put("location", new dLocation(event.getLocation()));
        String determination = BukkitWorldScriptHelper.doEvents(events, entity.isCitizensNPC() ? entity.getDenizenNPC() : null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }
}

