/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.scriptevents;

import java.util.HashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.FormatScriptContainer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatScriptEvent
extends ScriptEvent
implements Listener {
    public static ChatScriptEvent instance;
    public PlayerChatEvent pcEvent;
    public AsyncPlayerChatEvent apcEvent;
    public Element message;
    public Element format;
    public dPlayer player;
    public SyncChatHandler sch = new SyncChatHandler();
    public AsyncChatHandler asch = new AsyncChatHandler();
    boolean async = false;

    public ChatScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player chats");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        return true;
    }

    @Override
    public String getName() {
        return "Chat";
    }

    @Override
    public void init() {
        this.async = Settings.worldScriptChatEventAsynchronous();
        if (this.async) {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)this.asch, (Plugin)DenizenAPI.getCurrentInstance());
        } else {
            Bukkit.getServer().getPluginManager().registerEvents((Listener)this.sch, (Plugin)DenizenAPI.getCurrentInstance());
        }
    }

    @Override
    public void destroy() {
        if (this.async) {
            AsyncPlayerChatEvent.getHandlerList().unregister((Listener)this.asch);
        } else {
            PlayerChatEvent.getHandlerList().unregister((Listener)this.sch);
        }
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.startsWith("format:")) {
            String name = determination.substring(7);
            FormatScriptContainer formatscr = (FormatScriptContainer)ScriptRegistry.getScriptContainer(name);
            if (formatscr == null) {
                net.aufdemrand.denizen.utilities.debugging.dB.echoError("Could not find format script matching '" + name + '\'');
            } else {
                String formatstr = formatscr.getFormatText(null, this.player);
                if (dB.verbose) {
                    net.aufdemrand.denizen.utilities.debugging.dB.log("Setting format to " + formatstr);
                }
                this.format = new Element(formatstr);
            }
            return true;
        }
        if (!lower.startsWith("cancelled")) {
            this.message = new Element(determination);
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("message", this.message);
        context.put("format", this.format);
        return context;
    }

    class AsyncChatHandler
    implements Listener {
        AsyncChatHandler() {
        }

        @EventHandler
        public void onAsyncChat(AsyncPlayerChatEvent event) {
            ChatScriptEvent.this.message = new Element(event.getMessage());
            ChatScriptEvent.this.format = new Element(event.getFormat());
            ChatScriptEvent.this.cancelled = event.isCancelled();
            ChatScriptEvent.this.pcEvent = null;
            ChatScriptEvent.this.apcEvent = event;
            ChatScriptEvent.this.fire();
            event.setCancelled(ChatScriptEvent.this.cancelled);
            event.setMessage(ChatScriptEvent.this.message.asString());
            event.setFormat(ChatScriptEvent.this.format.asString());
        }
    }

    class SyncChatHandler
    implements Listener {
        SyncChatHandler() {
        }

        @EventHandler
        public void onSyncChat(PlayerChatEvent event) {
            ChatScriptEvent.this.message = new Element(event.getMessage());
            ChatScriptEvent.this.format = new Element(event.getFormat());
            ChatScriptEvent.this.cancelled = event.isCancelled();
            ChatScriptEvent.this.pcEvent = event;
            ChatScriptEvent.this.apcEvent = null;
            ChatScriptEvent.this.fire();
            event.setCancelled(ChatScriptEvent.this.cancelled);
            event.setMessage(ChatScriptEvent.this.message.asString());
            event.setFormat(ChatScriptEvent.this.format.asString());
        }
    }
}

