/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.scriptevents;

import java.util.HashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTeleportScriptEvent
extends ScriptEvent
implements Listener {
    public static EntityTeleportScriptEvent instance;
    public dEntity entity;
    public dLocation from;
    public dLocation to;
    public String cause;
    public EntityTeleportEvent event;
    public PlayerTeleportEvent pEvent;

    public EntityTeleportScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return CoreUtilities.xthArgEquals(1, lower, "teleports");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String eName = this.entity.getEntityType().getLowercaseName();
        String eName2 = this.entity.identifySimple().substring(2);
        String eName3 = this.entity.identifySimpleType();
        return lower.startsWith("entity") || lower.startsWith(eName) || lower.startsWith(eName2) || lower.startsWith(eName3);
    }

    @Override
    public String getName() {
        return "EntityTeleports";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        EntityTeleportEvent.getHandlerList().unregister((Listener)this);
        PlayerTeleportEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        dLocation new_to;
        String dlow = determination.toLowerCase();
        if (dlow.startsWith("origin:")) {
            dLocation new_from = dLocation.valueOf(determination.substring("origin:".length()));
            if (new_from != null) {
                this.from = new_from;
                return true;
            }
        } else if (dlow.startsWith("destination:")) {
            dLocation new_to2 = dLocation.valueOf(determination.substring("destination:".length()));
            if (new_to2 != null) {
                this.to = new_to2;
                return true;
            }
        } else if (dLocation.matches(determination) && (new_to = dLocation.valueOf(determination)) != null) {
            this.to = new_to;
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.pEvent != null ? dEntity.getPlayerFrom((Entity)this.pEvent.getPlayer()) : null, this.entity.isCitizensNPC() ? this.entity.getDenizenNPC() : null);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("origin", this.from);
        context.put("destination", this.to);
        context.put("entity", this.entity.getDenizenObject());
        context.put("cause", new Element(this.cause));
        return context;
    }

    @EventHandler
    public void onEntityTeleports(EntityTeleportEvent event) {
        this.to = new dLocation(event.getTo());
        this.from = new dLocation(event.getFrom());
        this.entity = new dEntity(event.getEntity());
        this.cancelled = event.isCancelled();
        this.cause = "ENTITY_TELEPORT";
        this.event = event;
        this.pEvent = null;
        this.fire();
        event.setCancelled(this.cancelled);
        event.setFrom((Location)this.from);
        event.setTo((Location)this.to);
    }

    @EventHandler
    public void onPlayerTeleports(PlayerTeleportEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.from = new dLocation(event.getFrom());
        this.to = new dLocation(event.getTo());
        this.entity = new dEntity((Entity)event.getPlayer());
        this.cancelled = event.isCancelled();
        this.cause = event.getCause().name();
        this.event = null;
        this.pEvent = event;
        this.fire();
        event.setCancelled(this.cancelled);
        event.setFrom((Location)this.from);
        event.setTo((Location)this.to);
    }
}

