/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.Denizen;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.npc.actions.ActionHandler;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Equipment;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dNPCRegistry
implements Listener {
    private static Map<Integer, dNPC> denizenNPCs = new ConcurrentHashMap<Integer, dNPC>(8, 0.9f, 1);
    private static Map<Integer, Inventory> npcInventories = new ConcurrentHashMap<Integer, Inventory>(8, 0.9f, 1);
    private Denizen plugin;
    private ActionHandler actionHandler;

    public static dNPCRegistry getCurrentInstance() {
        return DenizenAPI.getCurrentInstance().getNPCRegistry();
    }

    public dNPCRegistry(Denizen denizen) {
        this.plugin = denizen;
        if (Depends.citizens != null) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
        this.actionHandler = new ActionHandler(this.plugin);
    }

    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    public static boolean _isRegistered(NPC npc) {
        return denizenNPCs.containsKey(npc.getId());
    }

    public static boolean _isRegistered(int id) {
        return denizenNPCs.containsKey(id);
    }

    public static void _registerNPC(dNPC denizenNPC) {
        if (denizenNPC == null || !denizenNPC.isValid()) {
            return;
        }
        int id = denizenNPC.getId();
        if (!denizenNPCs.containsKey(id)) {
            denizenNPCs.put(id, denizenNPC);
            Inventory npcInventory = Bukkit.getServer().createInventory((InventoryHolder)denizenNPC, InventoryType.PLAYER);
            npcInventory.setContents(denizenNPC.getInventoryTrait().getContents());
            npcInventories.put(id, npcInventory);
        }
    }

    private static void _registerNPC(NPC npc) {
        if (npc == null) {
            return;
        }
        if (!denizenNPCs.containsKey(npc.getId())) {
            dNPCRegistry._registerNPC(new dNPC(npc));
        }
    }

    public static dNPC getDenizen(NPC npc) {
        if (npc == null) {
            return null;
        }
        if (!denizenNPCs.containsKey(npc.getId())) {
            dNPCRegistry._registerNPC(npc);
        }
        return denizenNPCs.get(npc.getId());
    }

    public static dNPC getDenizen(int id) {
        if (denizenNPCs.containsKey(id)) {
            return denizenNPCs.get(id);
        }
        return null;
    }

    public static Inventory getInventory(NPC npc) {
        if (npc == null) {
            return null;
        }
        if (!npcInventories.containsKey(npc.getId())) {
            dNPCRegistry._registerNPC(npc);
        }
        return npcInventories.get(npc.getId());
    }

    public static Set<dNPC> getSpawnedNPCs() {
        Iterator<Map.Entry<Integer, dNPC>> it = denizenNPCs.entrySet().iterator();
        HashSet<dNPC> npcs = new HashSet<dNPC>();
        while (it.hasNext()) {
            Map.Entry<Integer, dNPC> npc = it.next();
            if (npc.getValue().getCitizen() == null) {
                dB.log(ChatColor.RED + "Removed NPC from dRegistry.");
                try {
                    denizenNPCs.remove(npc.getKey());
                }
                catch (Exception e) {
                    dB.echoError("Report this error to aufdemrand! Err: posconcurrency1");
                }
                continue;
            }
            if (!npc.getValue().isSpawned()) continue;
            npcs.add(npc.getValue());
        }
        return npcs;
    }

    @EventHandler
    public void onSpawn(NPCSpawnEvent event) {
        dNPCRegistry._registerNPC(event.getNPC());
        OldEventManager.doEvents(Arrays.asList("npc spawns"), new BukkitScriptEntryData(null, dNPC.mirrorCitizensNPC(event.getNPC())), null);
        dNPCRegistry.getDenizen(event.getNPC()).action("spawn", null);
    }

    @EventHandler
    public void despawn(NPCDespawnEvent event) {
        dNPC npc = dNPCRegistry.getDenizen(event.getNPC().getId());
        if (npc != null) {
            OldEventManager.doEvents(Arrays.asList("npc despawns"), new BukkitScriptEntryData(null, npc), null);
        }
        if (npc != null) {
            npc.action("despawn", null);
        }
    }

    @EventHandler
    public void onRemove(NPCRemoveEvent event) {
        NPC npc = event.getNPC();
        dNPCRegistry.getDenizen(npc).action("remove", null);
        if (dNPCRegistry._isRegistered(npc)) {
            denizenNPCs.remove(npc.getId());
            npcInventories.remove(npc.getId());
        }
        FlagManager.clearNPCFlags(npc.getId());
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        if (inventory.getHolder() instanceof dNPC) {
            dNPC npc = (dNPC)inventory.getHolder();
            npc.getInventory().setContents(inventory.getContents());
            Equipment equipment = npc.getEquipmentTrait();
            for (int i = 0; i < 5; ++i) {
                equipment.set(i, inventory.getItem(i));
            }
        }
    }
}

