/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.npc.traits;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.util.PlayerAnimation;
import net.minecraft.server.v1_8_R1.Block;
import net.minecraft.server.v1_8_R1.Blocks;
import net.minecraft.server.v1_8_R1.EnchantmentManager;
import net.minecraft.server.v1_8_R1.Entity;
import net.minecraft.server.v1_8_R1.EntityFishingHook;
import net.minecraft.server.v1_8_R1.EntityHuman;
import net.minecraft.server.v1_8_R1.EntityItem;
import net.minecraft.server.v1_8_R1.EntityLiving;
import net.minecraft.server.v1_8_R1.EnumFish;
import net.minecraft.server.v1_8_R1.Item;
import net.minecraft.server.v1_8_R1.ItemStack;
import net.minecraft.server.v1_8_R1.Items;
import net.minecraft.server.v1_8_R1.MathHelper;
import net.minecraft.server.v1_8_R1.PossibleFishingResult;
import net.minecraft.server.v1_8_R1.StatisticList;
import net.minecraft.server.v1_8_R1.WeightedRandom;
import net.minecraft.server.v1_8_R1.World;
import net.minecraft.server.v1_8_R1.WorldServer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class FishingTrait
extends Trait {
    private static final List junkResults = Arrays.asList(new PossibleFishingResult(new ItemStack((Item)Items.LEATHER_BOOTS), 10).a(0.9f), new PossibleFishingResult(new ItemStack(Items.LEATHER), 10), new PossibleFishingResult(new ItemStack(Items.BONE), 10), new PossibleFishingResult(new ItemStack((Item)Items.POTION), 10), new PossibleFishingResult(new ItemStack(Items.STRING), 5), new PossibleFishingResult(new ItemStack((Item)Items.FISHING_ROD), 2).a(0.9f), new PossibleFishingResult(new ItemStack(Items.BOWL), 10), new PossibleFishingResult(new ItemStack(Items.STICK), 5), new PossibleFishingResult(new ItemStack(Items.DYE, 10, 0), 1), new PossibleFishingResult(new ItemStack((Block)Blocks.TRIPWIRE_HOOK), 10), new PossibleFishingResult(new ItemStack(Items.ROTTEN_FLESH), 10));
    private static final List treasureResults = Arrays.asList(new PossibleFishingResult(new ItemStack(Blocks.WATERLILY), 1), new PossibleFishingResult(new ItemStack(Items.NAME_TAG), 1), new PossibleFishingResult(new ItemStack(Items.SADDLE), 1), new PossibleFishingResult(new ItemStack((Item)Items.BOW), 1).a(0.25f).a(), new PossibleFishingResult(new ItemStack((Item)Items.FISHING_ROD), 1).a(0.25f).a(), new PossibleFishingResult(new ItemStack(Items.BOOK), 1).a());
    private static final List fishResults = Arrays.asList(new PossibleFishingResult(new ItemStack(Items.FISH, 1, EnumFish.COD.a()), 60), new PossibleFishingResult(new ItemStack(Items.FISH, 1, EnumFish.SALMON.a()), 25), new PossibleFishingResult(new ItemStack(Items.FISH, 1, EnumFish.CLOWNFISH.a()), 2), new PossibleFishingResult(new ItemStack(Items.FISH, 1, EnumFish.PUFFERFISH.a()), 13));
    @Persist(value="fishing")
    private boolean fishing = false;
    @Persist(value="catch type")
    private CatchType catchType = CatchType.NONE;
    @Persist(value="fishing spot")
    private Location fishingLocation = null;
    ArrayList<Location> available = new ArrayList();
    EntityHuman eh = null;
    WorldServer nmsworld = null;
    Location fishingSpot = null;
    EntityFishingHook fishHook = null;
    EntityItem fish = null;
    @Persist(value="catch chance")
    int catchPercent = 65;
    int reelCount = 100;
    int castCount = 0;

    public void run() {
        ++this.reelCount;
        ++this.castCount;
        if (this.fish != null && this.fish.getBukkitEntity().getLocation().distance(this.npc.getBukkitEntity().getLocation()) < 3.0) {
            try {
                this.fish.getBukkitEntity().remove();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.fishing) {
            return;
        }
        if (this.reelCount == 400) {
            this.reel();
            this.reelCount = 0;
            this.castCount = 325;
        }
        if (this.castCount == 400) {
            this.cast();
            this.castCount = 0;
        }
    }

    public void onSpawn() {
        this.eh = ((CraftPlayer)this.npc.getBukkitEntity()).getHandle();
        this.nmsworld = ((CraftWorld)this.npc.getBukkitEntity().getWorld()).getHandle();
    }

    public void startFishing(Location location) {
        DenizenAPI.getDenizenNPC(this.npc).action("start fishing", null);
        this.fishingLocation = location.clone();
        this.cast();
        this.fishing = true;
    }

    public void stopFishing() {
        DenizenAPI.getDenizenNPC(this.npc).action("stop fishing", null);
        this.reel();
        this.reelCount = 100;
        this.castCount = 0;
        this.fishingLocation = null;
        this.fishing = false;
    }

    public void startFishing() {
        this.fishing = true;
        this.fishingLocation = this.npc.getBukkitEntity().getLocation();
    }

    private void cast() {
        DenizenAPI.getDenizenNPC(this.npc).action("cast fishing rod", null);
        if (this.fishingLocation == null) {
            dB.echoError("Fishing location not found!");
            return;
        }
        double v = 34.0;
        double g = 20.0;
        Location from = null;
        Location to = null;
        this.fishHook = new EntityFishingHook((World)this.nmsworld, this.eh);
        this.nmsworld.addEntity((Entity)this.fishHook);
        from = this.npc.getBukkitEntity().getLocation();
        from = from.add(0.0, 0.33, 0.0);
        to = this.fishingLocation;
        Vector test = to.clone().subtract(from).toVector();
        Double elev = test.getY();
        Double testAngle = FishingTrait.launchAngle(from, to, v, elev, g);
        if (testAngle == null) {
            return;
        }
        Double hangtime = FishingTrait.hangtime(testAngle, v, elev, g);
        Vector victor = to.clone().subtract(from).toVector();
        Double dist = Math.sqrt(Math.pow(victor.getX(), 2.0) + Math.pow(victor.getZ(), 2.0));
        elev = victor.getY();
        if (dist == 0.0) {
            return;
        }
        Double launchAngle = FishingTrait.launchAngle(from, to, v, elev, g);
        if (launchAngle == null) {
            return;
        }
        victor.setY(Math.tan(launchAngle) * dist);
        victor = FishingTrait.normalizeVector(victor);
        v += 0.5 * Math.pow(hangtime, 2.0);
        victor = victor.multiply((v += (CoreUtilities.getRandom().nextDouble() - 0.8) / 2.0) / 20.0);
        Projectile theHook = (Projectile)this.fishHook.getBukkitEntity();
        theHook.setShooter((ProjectileSource)this.npc.getBukkitEntity());
        theHook.setVelocity(victor);
        PlayerAnimation.ARM_SWING.play((Player)this.npc.getBukkitEntity());
    }

    private void reel() {
        DenizenAPI.getDenizenNPC(this.npc).action("reel in fishing rod", null);
        int chance = (int)(Math.random() * 100.0);
        try {
            this.fishHook.getBukkitEntity().remove();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.catchPercent > chance && this.fishHook != null && this.catchType != CatchType.NONE) {
            try {
                this.fish.getBukkitEntity().remove();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.fish = new EntityItem((World)this.nmsworld, this.fishHook.locX, this.fishHook.locY, this.fishHook.locZ, this.getFishingResult());
            double d5 = this.npc.getBukkitEntity().getLocation().getX() - this.fishHook.locX;
            double d6 = this.npc.getBukkitEntity().getLocation().getY() - this.fishHook.locY;
            double d7 = this.npc.getBukkitEntity().getLocation().getZ() - this.fishHook.locZ;
            double d8 = MathHelper.sqrt((double)(d5 * d5 + d6 * d6 + d7 * d7));
            double d9 = 0.1;
            this.fish.motX = d5 * d9;
            this.fish.motY = d6 * d9 + (double)MathHelper.sqrt((double)d8) * 0.08;
            this.fish.motZ = d7 * d9;
            this.nmsworld.addEntity((Entity)this.fish);
            DenizenAPI.getDenizenNPC(this.npc).action("catch fish", null);
        }
        PlayerAnimation.ARM_SWING.play((Player)this.npc.getBukkitEntity());
    }

    public ItemStack getFishingResult() {
        if (this.catchType == CatchType.DEFAULT) {
            float f = this.nmsworld.random.nextFloat();
            int i = EnchantmentManager.g((EntityLiving)this.fishHook.owner);
            int j = EnchantmentManager.h((EntityLiving)this.fishHook.owner);
            float f1 = 0.1f - (float)i * 0.025f - (float)j * 0.01f;
            float f2 = 0.05f + (float)i * 0.01f - (float)j * 0.01f;
            f1 = MathHelper.a((float)f1, (float)0.0f, (float)1.0f);
            f2 = MathHelper.a((float)f2, (float)0.0f, (float)1.0f);
            if (f < f1) {
                return this.catchRandomJunk();
            }
            if ((f -= f1) < f2) {
                return this.catchRandomTreasure();
            }
            return this.catchRandomFish();
        }
        if (this.catchType == CatchType.JUNK) {
            return this.catchRandomJunk();
        }
        if (this.catchType == CatchType.TREASURE) {
            return this.catchRandomTreasure();
        }
        if (this.catchType == CatchType.FISH) {
            return this.catchRandomFish();
        }
        return null;
    }

    private ItemStack catchRandomJunk() {
        this.fishHook.owner.a(StatisticList.A, 1);
        return ((PossibleFishingResult)WeightedRandom.a((Random)CoreUtilities.getRandom(), (Collection)junkResults)).a(CoreUtilities.getRandom());
    }

    private ItemStack catchRandomTreasure() {
        this.fishHook.owner.a(StatisticList.B, 1);
        return ((PossibleFishingResult)WeightedRandom.a((Random)CoreUtilities.getRandom(), (Collection)treasureResults)).a(CoreUtilities.getRandom());
    }

    private ItemStack catchRandomFish() {
        this.fishHook.owner.a(StatisticList.z, 1);
        return ((PossibleFishingResult)WeightedRandom.a((Random)CoreUtilities.getRandom(), (Collection)fishResults)).a(CoreUtilities.getRandom());
    }

    public boolean isFishing() {
        return this.fishing;
    }

    public Location getFishingLocation() {
        return this.fishingLocation;
    }

    public FishingTrait() {
        super("fishing");
    }

    public static Double launchAngle(Location from, Location to, double v, double elev, double g) {
        double derp;
        Vector victor = from.clone().subtract(to).toVector();
        Double dist = Math.sqrt(Math.pow(victor.getX(), 2.0) + Math.pow(victor.getZ(), 2.0));
        double v2 = Math.pow(v, 2.0);
        double v4 = Math.pow(v, 4.0);
        if (v4 < (derp = g * (g * Math.pow(dist, 2.0) + 2.0 * elev * v2))) {
            return null;
        }
        return Math.atan((v2 - Math.sqrt(v4 - derp)) / (g * dist));
    }

    public static double hangtime(double launchAngle, double v, double elev, double g) {
        double a = v * Math.sin(launchAngle);
        double b = -2.0 * g * elev;
        if (Math.pow(a, 2.0) + b < 0.0) {
            return 0.0;
        }
        return (a + Math.sqrt(Math.pow(a, 2.0) + b)) / g;
    }

    public static Vector normalizeVector(Vector victor) {
        double mag = Math.sqrt(Math.pow(victor.getX(), 2.0) + Math.pow(victor.getY(), 2.0) + Math.pow(victor.getZ(), 2.0));
        if (mag != 0.0) {
            return victor.multiply(1.0 / mag);
        }
        return victor.multiply(0);
    }

    public void setCatchType(CatchType catchType) {
        this.catchType = catchType;
    }

    public void setCatchPercent(int catchPercent) {
        this.catchPercent = catchPercent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CatchType {
        NONE,
        DEFAULT,
        JUNK,
        TREASURE,
        FISH;

    }
}

