/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.objects.properties.item.ItemBook;
import net.aufdemrand.denizen.objects.properties.item.ItemDurability;
import net.aufdemrand.denizen.objects.properties.item.ItemDye;
import net.aufdemrand.denizen.objects.properties.item.ItemFirework;
import net.aufdemrand.denizen.objects.properties.item.ItemPlantgrowth;
import net.aufdemrand.denizen.scripts.containers.core.BookScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptHelper;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.notable.Notable;
import net.aufdemrand.denizencore.objects.notable.Note;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_8_R1.inventory.CraftItemStack;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class dItem
implements dObject,
Notable,
Adjustable {
    static final Pattern ITEM_PATTERN = Pattern.compile("(?:item:)?([\\w ]+)[:,]?(\\d+)?\\[?(\\d+)?\\]?", 2);
    static final Pattern item_by_saved = Pattern.compile("(i@)(.+)\\[?(\\d+)?\\]?");
    public static final String itemscriptIdentifier = "\u00a70id:";
    public static boolean nope = false;
    private ItemStack item = null;
    private String prefix = this.getObjectType();

    public static dItem valueOf(String string) {
        return dItem.valueOf(string, null);
    }

    @Fetchable(value="i")
    public static dItem valueOf(String string, TagContext context) {
        if (context == null) {
            return dItem.valueOf(string, null, null);
        }
        return dItem.valueOf(string, ((BukkitTagContext)context).player, ((BukkitTagContext)context).npc);
    }

    public static dItem valueOf(String string, dPlayer player, dNPC npc) {
        block20: {
            if (string == null) {
                return null;
            }
            dItem stack = null;
            Matcher m = ObjectFetcher.DESCRIBED_PATTERN.matcher(string);
            if (m.matches()) {
                return ObjectFetcher.getObjectFrom(dItem.class, string, new BukkitTagContext(player, npc, false, null, true, null));
            }
            m = item_by_saved.matcher(string);
            if (m.matches() && NotableManager.isSaved(m.group(2)) && NotableManager.isType(m.group(2), dItem.class)) {
                stack = (dItem)NotableManager.getSavedObject(m.group(2));
                if (m.group(3) != null) {
                    stack.setAmount(Integer.valueOf(m.group(3)));
                }
                return stack;
            }
            m = ITEM_PATTERN.matcher(string = string.replace("i@", ""));
            if (m.matches()) {
                try {
                    if (ScriptRegistry.containsScript(m.group(1), ItemScriptContainer.class)) {
                        stack = ScriptRegistry.getScriptContainerAs(m.group(1), ItemScriptContainer.class).getItemFrom(player, npc);
                    } else if (ScriptRegistry.containsScript(m.group(1), BookScriptContainer.class)) {
                        stack = ScriptRegistry.getScriptContainerAs(m.group(1), BookScriptContainer.class).getBookFrom(player, npc);
                    }
                    if (stack != null) {
                        if (m.group(3) != null) {
                            stack.setAmount(Integer.valueOf(m.group(3)));
                        }
                        return stack;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    String material = m.group(1).toUpperCase();
                    if (aH.matchesInteger(material)) {
                        stack = new dItem(Integer.valueOf(material));
                    } else {
                        dMaterial mat = dMaterial.valueOf(material);
                        stack = new dItem(mat.getMaterial());
                        if (mat.hasData()) {
                            stack.setDurability(mat.getData().byteValue());
                        }
                    }
                    if (m.group(2) != null) {
                        stack.setDurability(Short.valueOf(m.group(2)));
                    }
                    if (m.group(3) != null) {
                        stack.setAmount(Integer.valueOf(m.group(3)));
                    }
                    return stack;
                }
                catch (Exception e) {
                    if (string.equalsIgnoreCase("none") || nope) break block20;
                    dB.log("Does not match a valid item ID or material: " + string);
                }
            }
        }
        if (!nope) {
            dB.log("valueOf dItem returning null: " + string);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg == null) {
            return false;
        }
        if (arg.toLowerCase().startsWith("i@")) {
            return true;
        }
        if (ScriptRegistry.containsScript(arg, ItemScriptContainer.class)) {
            return true;
        }
        if (ScriptRegistry.containsScript(arg, BookScriptContainer.class)) {
            return true;
        }
        nope = true;
        if (dItem.valueOf(arg) != null) {
            nope = false;
            return true;
        }
        nope = false;
        return false;
    }

    public dItem(Material material) {
        this(new ItemStack(material));
    }

    public dItem(int itemId) {
        this(new ItemStack(itemId));
    }

    public dItem(Material material, int qty) {
        this(new ItemStack(material, qty));
    }

    public dItem(dMaterial material, int qty) {
        this(new ItemStack(material.getMaterial(), qty, 0, material.getData()));
    }

    public dItem(int type, int qty) {
        this(new ItemStack(type, qty));
    }

    public dItem(ItemStack item) {
        this.item = item == null ? new ItemStack(Material.AIR) : item;
    }

    public dItem(Item item) {
        this(item.getItemStack());
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public void setItemStack(ItemStack item) {
        this.item = item;
    }

    public int comparesTo(dItem item) {
        return this.comparesTo(item.getItemStack());
    }

    public int comparesTo(ItemStack item) {
        if (item == null) {
            return -1;
        }
        int determination = 0;
        ItemStack compared = this.getItemStack();
        ItemStack compared_to = item;
        if (compared.getTypeId() != compared_to.getTypeId()) {
            return -1;
        }
        if (compared_to.hasItemMeta()) {
            if (!compared.hasItemMeta()) {
                return -1;
            }
            if (compared_to.getItemMeta().hasDisplayName()) {
                if (!compared.getItemMeta().hasDisplayName()) {
                    return -1;
                }
                if (compared_to.getItemMeta().getDisplayName().toUpperCase().startsWith(compared.getItemMeta().getDisplayName().toUpperCase())) {
                    if (compared.getItemMeta().getDisplayName().length() > compared_to.getItemMeta().getDisplayName().length()) {
                        ++determination;
                    }
                } else {
                    return -1;
                }
            }
            if (compared_to.getItemMeta().hasLore()) {
                if (!compared.getItemMeta().hasLore()) {
                    return -1;
                }
                for (String string : compared_to.getItemMeta().getLore()) {
                    if (compared.getItemMeta().getLore().contains(string)) continue;
                    return -1;
                }
                if (compared.getItemMeta().getLore().size() > compared_to.getItemMeta().getLore().size()) {
                    ++determination;
                }
            }
            if (!compared_to.getItemMeta().getEnchants().isEmpty()) {
                if (compared.getItemMeta().getEnchants().isEmpty()) {
                    return -1;
                }
                for (Map.Entry entry : compared_to.getItemMeta().getEnchants().entrySet()) {
                    if (compared.getItemMeta().getEnchants().containsKey(entry.getKey()) && (Integer)compared.getItemMeta().getEnchants().get(entry.getKey()) >= (Integer)entry.getValue()) continue;
                    return -1;
                }
                if (compared.getItemMeta().getEnchants().size() > compared_to.getItemMeta().getEnchants().size()) {
                    ++determination;
                }
            }
        }
        if (this.isRepairable()) {
            if (compared.getDurability() < compared_to.getDurability()) {
                ++determination;
            }
        } else if (this.getItemStack().getData().getData() != item.getData().getData()) {
            return -1;
        }
        return determination;
    }

    public void setStackSize(int size) {
        this.getItemStack().setAmount(size);
    }

    public boolean containsLore(String prefix) {
        if (this.getItemStack().hasItemMeta() && this.getItemStack().getItemMeta().hasLore()) {
            for (String itemLore : this.getItemStack().getItemMeta().getLore()) {
                if (!itemLore.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public String getLore(String prefix) {
        for (String itemLore : this.getItemStack().getItemMeta().getLore()) {
            if (!itemLore.startsWith(prefix)) continue;
            return itemLore.substring(prefix.length());
        }
        return "";
    }

    public boolean isItemscript() {
        return ItemScriptHelper.isItemscript(this.item);
    }

    public String getScriptName() {
        ItemScriptContainer cont = ItemScriptHelper.getItemScriptContainer(this.item);
        if (cont != null) {
            return cont.getName();
        }
        return null;
    }

    public dMaterial getMaterial() {
        return dMaterial.getMaterialFrom(this.getItemStack().getType(), this.getItemStack().getData().getData());
    }

    public String getMaterialName() {
        return this.getItemStack().getType().name().toLowerCase();
    }

    public void setAmount(int value) {
        if (this.item != null) {
            this.item.setAmount(value);
        }
    }

    public int getMaxStackSize() {
        return this.item.getMaxStackSize();
    }

    public int getAmount() {
        if (this.item != null) {
            return this.item.getAmount();
        }
        return 0;
    }

    public void setDurability(short value) {
        if (this.item != null) {
            this.item.setDurability(value);
        }
    }

    public void setData(byte value) {
        if (this.item != null) {
            this.item.getData().setData(value);
        }
    }

    public boolean isRepairable() {
        return this.item.getType().getMaxDurability() > 0;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public dItem setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getObjectType() {
        return "Item";
    }

    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    public String identify() {
        if (this.item == null) {
            return "null";
        }
        if (this.item.getTypeId() != 0) {
            if (this.isUnique()) {
                return "i@" + NotableManager.getSavedId(this) + (this.item.getAmount() == 1 ? "" : "[quantity=" + this.item.getAmount() + "]");
            }
            if (this.isItemscript()) {
                return "i@" + this.getScriptName() + (this.item.getAmount() == 1 ? "" : "[quantity=" + this.item.getAmount() + "]");
            }
        }
        if (this.item.getDurability() >= 16 || this.item.getDurability() < 0) {
            return "i@" + this.getMaterial().realName() + "," + this.item.getDurability() + PropertyParser.getPropertiesString(this);
        }
        return "i@" + this.getMaterial().identify().replace("m@", "") + PropertyParser.getPropertiesString(this);
    }

    public String identifySimple() {
        if (this.item == null) {
            return "null";
        }
        if (this.item.getTypeId() != 0) {
            if (this.isUnique()) {
                return "i@" + NotableManager.getSavedId(this);
            }
            if (this.isItemscript()) {
                return "i@" + this.getScriptName();
            }
        }
        return "i@" + this.identifyMaterial().replace("m@", "");
    }

    public String identifyMaterial() {
        return dMaterial.getMaterialFrom(this.item.getType(), this.item.getData().getData()).identifySimple();
    }

    public String identifyMaterialNoIdentifier() {
        return dMaterial.getMaterialFrom(this.item.getType(), this.item.getData().getData()).identifySimpleNoIdentifier();
    }

    public String identifyNoIdentifier() {
        if (this.item == null) {
            return "null";
        }
        if (this.item.getTypeId() != 0) {
            if (this.isUnique()) {
                return NotableManager.getSavedId(this) + (this.item.getAmount() == 1 ? "" : "[quantity=" + this.item.getAmount() + "]");
            }
            if (this.isItemscript()) {
                return this.getScriptName() + (this.item.getAmount() == 1 ? "" : "[quantity=" + this.item.getAmount() + "]");
            }
        }
        if (this.item.getDurability() >= 16 || this.item.getDurability() < 0) {
            return this.getMaterial().realName() + "," + this.item.getDurability() + PropertyParser.getPropertiesString(this);
        }
        return this.getMaterial().identifyNoIdentifier() + PropertyParser.getPropertiesString(this);
    }

    public String identifySimpleNoIdentifier() {
        if (this.item == null) {
            return "null";
        }
        if (this.item.getTypeId() != 0) {
            if (this.isUnique()) {
                return NotableManager.getSavedId(this);
            }
            if (this.isItemscript()) {
                return this.getScriptName();
            }
        }
        return this.identifyMaterialNoIdentifier();
    }

    public String getFullString() {
        return "i@" + (this.isItemscript() ? this.getScriptName() : this.getMaterial().realName()) + "," + this.item.getDurability() + PropertyParser.getPropertiesString(this);
    }

    public String toString() {
        return this.identify();
    }

    public boolean isUnique() {
        return NotableManager.isSaved(this);
    }

    @Note(value="Items")
    public String getSaveObject() {
        return this.getFullString();
    }

    public void makeUnique(String id) {
        NotableManager.saveAs(this, id);
    }

    public void forget() {
        NotableManager.remove(this);
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("id")) {
            return new Element(this.getItemStack().getTypeId()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("data")) {
            return new Element(this.getItemStack().getData().getData()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("repairable")) {
            return new Element(ItemDurability.describes(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_crop")) {
            return new Element(ItemPlantgrowth.describes(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_book")) {
            return new Element(ItemBook.describes(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_dyeable")) {
            return new Element(ItemDye.describes(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_firework")) {
            return new Element(ItemFirework.describes(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("material.formatted")) {
            attribute.fulfill(1);
        }
        if (attribute.startsWith("formatted")) {
            String id = this.getMaterial().realName().toLowerCase().replace('_', ' ');
            if (id.equals("air")) {
                return new Element("nothing").getAttribute(attribute.fulfill(1));
            }
            if (id.equals("ice") || id.equals("dirt")) {
                return new Element(id).getAttribute(attribute.fulfill(1));
            }
            if (this.getItemStack().getAmount() > 1) {
                if (id.equals("cactus")) {
                    return new Element("cactuses").getAttribute(attribute.fulfill(1));
                }
                if (id.endsWith("y")) {
                    return new Element(id.substring(0, id.length() - 1) + "ies").getAttribute(attribute.fulfill(1));
                }
                if (id.endsWith("s")) {
                    return new Element(id).getAttribute(attribute.fulfill(1));
                }
                return new Element(id + "s").getAttribute(attribute.fulfill(1));
            }
            if (id.equals("cactus")) {
                return new Element("a cactus").getAttribute(attribute.fulfill(1));
            }
            if (id.endsWith("s")) {
                return new Element(id).getAttribute(attribute.fulfill(1));
            }
            if (id.startsWith("a") || id.startsWith("e") || id.startsWith("i") || id.startsWith("o") || id.startsWith("u")) {
                return new Element("an " + id).getAttribute(attribute.fulfill(1));
            }
            return new Element("a " + id).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("material")) {
            return this.getMaterial().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("json")) {
            String JSON = CraftItemStack.asNMSCopy((ItemStack)this.item).C().getChatModifier().toString();
            return new Element(JSON.substring(176, JSON.length() - 186)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("full")) {
            return new Element(this.getFullString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("simple")) {
            return new Element(this.identifySimple()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("notable_name")) {
            return new Element(NotableManager.getSavedId(this)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("scriptname") && this.isItemscript()) {
            return new Element(this.getScriptName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element("Item").getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    public void applyProperty(Mechanism mechanism) {
        this.adjust(mechanism);
    }

    public void adjust(Mechanism mechanism) {
        for (Property property : PropertyParser.getProperties(this)) {
            property.adjust(mechanism);
            if (!mechanism.fulfilled()) continue;
            break;
        }
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
    }
}

