/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.entity;

import java.util.Arrays;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.npc.traits.HealthTrait;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class HealthCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("target") && arg.matches("player")) {
                if (!((BukkitScriptEntryData)scriptEntry.entryData).hasPlayer()) {
                    throw new InvalidArgumentsException("No player attached!");
                }
                scriptEntry.addObject("target", Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getDenizenEntity()));
                continue;
            }
            if (!scriptEntry.hasObject("qty") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("qty", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("target") && arg.matchesArgumentList(dEntity.class)) {
                scriptEntry.addObject("target", arg.asType(dList.class).filter(dEntity.class, scriptEntry));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("state")) {
                scriptEntry.addObject("action", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("qty") && !scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify a quantity!");
        }
        if (!scriptEntry.hasObject("target")) {
            if (!((BukkitScriptEntryData)scriptEntry.entryData).hasNPC()) {
                throw new InvalidArgumentsException("Missing NPC!");
            }
            scriptEntry.addObject("target", Arrays.asList(((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getDenizenEntity()));
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element qty = scriptEntry.getElement("qty");
        Element action = scriptEntry.getElement("action");
        List targets = (List)scriptEntry.getObject("target");
        dB.report(scriptEntry, this.getName(), (qty != null ? qty.debug() : "") + (action != null ? action.debug() : "") + aH.debugObj("target", targets.toString()));
        if (qty == null && action == null) {
            dB.echoError(scriptEntry.getResidingQueue(), "Null quantity!");
        }
        if (action == null) {
            action = Element.TRUE;
        }
        for (dEntity target : targets) {
            if (target.isCitizensNPC()) {
                if (action.asString().equalsIgnoreCase("true")) {
                    target.getDenizenNPC().getCitizen().addTrait(HealthTrait.class);
                } else if (action.asString().equalsIgnoreCase("false")) {
                    target.getDenizenNPC().getCitizen().removeTrait(HealthTrait.class);
                } else if (target.getDenizenNPC().getCitizen().hasTrait(HealthTrait.class)) {
                    target.getDenizenNPC().getCitizen().removeTrait(HealthTrait.class);
                } else {
                    target.getDenizenNPC().getCitizen().addTrait(HealthTrait.class);
                }
            }
            if (qty == null) continue;
            if (target.isCitizensNPC()) {
                if (target.getDenizenNPC().getCitizen().hasTrait(HealthTrait.class)) {
                    ((HealthTrait)target.getDenizenNPC().getCitizen().getTrait(HealthTrait.class)).setMaxhealth(qty.asInt());
                    continue;
                }
                dB.echoError(scriptEntry.getResidingQueue(), "NPC doesn't have health trait!");
                continue;
            }
            if (target.isLivingEntity()) {
                target.getLivingEntity().setMaxHealth(qty.asDouble());
                continue;
            }
            dB.echoError(scriptEntry.getResidingQueue(), "Entity '" + target.identify() + "'is not alive!");
        }
    }
}

