/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.triggers.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.npc.traits.ChatbotTrait;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptHelper;
import net.aufdemrand.denizen.scripts.triggers.AbstractTrigger;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.Rotation;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatTrigger
extends AbstractTrigger
implements Listener {
    static final Pattern triggerPattern = Pattern.compile("/([^/]*)/");
    static final boolean HyperDebug = false;

    public void onEnable() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public ChatContext process(Player player, String message) {
        dNPC npc = Utilities.getClosestNPC_ChatTrigger(player.getLocation(), 25);
        dPlayer denizenPlayer = dPlayer.mirrorBukkitPlayer((OfflinePlayer)player);
        if (npc == null) {
            return new ChatContext(false);
        }
        if (!npc.getCitizen().hasTrait(TriggerTrait.class)) {
            return new ChatContext(false);
        }
        if (!((TriggerTrait)npc.getCitizen().getTrait(TriggerTrait.class)).isEnabled(this.name)) {
            return new ChatContext(false);
        }
        if (npc.getTriggerTrait().getRadius(this.name) < npc.getLocation().distance(player.getLocation())) {
            return new ChatContext(false);
        }
        if (Settings.chatMustSeeNPC() && !player.hasLineOfSight(npc.getEntity())) {
            return new ChatContext(false);
        }
        if (Settings.chatMustLookAtNPC() && !Rotation.isFacingEntity((Entity)player, npc.getEntity(), 45.0f)) {
            return new ChatContext(false);
        }
        Boolean ret = false;
        InteractScriptContainer script = npc.getInteractScript(denizenPlayer, ChatTrigger.class);
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("message", new Element(message));
        TriggerTrait.TriggerContext trigger = npc.getTriggerTrait().trigger(this, denizenPlayer, context);
        if (trigger.hasDetermination() && trigger.getDetermination().equalsIgnoreCase("cancelled")) {
            return new ChatContext(true);
        }
        if (!trigger.wasTriggered()) {
            if (Settings.chatGloballyIfUninteractable()) {
                dB.echoDebug((Debuggable)script, ChatColor.YELLOW + "Resuming. " + ChatColor.WHITE + "The NPC is currently cooling down or engaged.");
                return new ChatContext(false);
            }
            ret = true;
        }
        dB.report(script, this.name, aH.debugObj("Player", player.getName()) + aH.debugObj("NPC", npc.toString()) + aH.debugObj("Radius(Max)", npc.getLocation().distance(player.getLocation()) + "(" + npc.getTriggerTrait().getRadius(this.name) + ")") + aH.debugObj("Trigger text", message) + aH.debugObj("LOS", String.valueOf(player.hasLineOfSight(npc.getEntity()))) + aH.debugObj("Facing", String.valueOf(Rotation.isFacingEntity((Entity)player, npc.getEntity(), 45.0f))));
        if (trigger.hasDetermination()) {
            message = trigger.getDetermination();
        }
        if (script == null) {
            return new ChatContext(message, false);
        }
        if (!script.containsTriggerInStep(InteractScriptHelper.getCurrentStep(denizenPlayer, script.getName()), ChatTrigger.class)) {
            if (npc.getCitizen().hasTrait(ChatbotTrait.class)) {
                Utilities.talkToNPC(message, denizenPlayer, npc, Settings.chatToNpcOverhearingRange());
                ((ChatbotTrait)npc.getCitizen().getTrait(ChatbotTrait.class)).chatTo((Entity)player, message);
                return new ChatContext(false);
            }
            if (!Settings.chatGloballyIfNoChatTriggers()) {
                dB.echoDebug((Debuggable)script, player.getName() + " says to " + npc.getNicknameTrait().getNickname() + ", " + message);
                return new ChatContext(false);
            }
            return new ChatContext(message, ret);
        }
        String id = null;
        boolean matched = false;
        String replacementText = null;
        String regexId = null;
        String regexMessage = null;
        TreeMap<String, String> idMap = new TreeMap<String, String>();
        idMap.putAll(script.getIdMapFor(ChatTrigger.class, denizenPlayer));
        if (!idMap.isEmpty()) {
            ArrayList entries = new ArrayList(idMap.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    if (o1 == null || o2 == null) {
                        return 0;
                    }
                    return o1.getKey().compareToIgnoreCase(o2.getKey());
                }
            });
            for (Map.Entry entry : entries) {
                String triggerText = TagManager.tag((String)entry.getValue(), new BukkitTagContext(denizenPlayer, npc, false, null, false, null));
                Matcher matcher = triggerPattern.matcher(triggerText);
                while (matcher.find()) {
                    if (!script.checkSpecificTriggerScriptRequirementsFor(ChatTrigger.class, denizenPlayer, npc, (String)entry.getKey())) continue;
                    String keyword = TagManager.tag(matcher.group().replace("/", ""), new BukkitTagContext(denizenPlayer, npc, false, null, false, null));
                    String[] split = keyword.split("\\\\\\+REPLACE:", 2);
                    String replace = null;
                    if (split.length == 2) {
                        keyword = split[0];
                        replace = split[1];
                    }
                    if (regexId == null && this.isKeywordRegex(keyword)) {
                        Pattern pattern = Pattern.compile(keyword.substring(6));
                        Matcher m = pattern.matcher(message);
                        if (!m.find()) continue;
                        regexId = (String)entry.getKey();
                        regexMessage = triggerText.replace(matcher.group(), m.group());
                        dB.log("entry value: " + triggerText + "  keyword: " + keyword + "  m.group: " + m.group() + "  matcher.group: " + matcher.group());
                        context.put("keyword", new Element(m.group()));
                        if (replace == null) continue;
                        regexMessage = replace;
                        continue;
                    }
                    if (this.isKeywordStrict(keyword)) {
                        if (!message.toUpperCase().equalsIgnoreCase(keyword.toUpperCase())) continue;
                        id = (String)entry.getKey();
                        replacementText = triggerText.replace("/", "");
                        matched = true;
                        if (replace == null) continue;
                        replacementText = replace;
                        continue;
                    }
                    if (!message.toUpperCase().contains(keyword.toUpperCase())) continue;
                    id = (String)entry.getKey();
                    replacementText = triggerText.replace("/", "");
                    matched = true;
                    if (replace == null) continue;
                    replacementText = replace;
                }
                if (!matched) continue;
                break;
            }
        }
        if (!matched && regexId != null) {
            id = regexId;
            replacementText = regexMessage;
        }
        if (id != null) {
            Utilities.talkToNPC(replacementText, denizenPlayer, npc, Settings.chatToNpcOverhearingRange());
            this.parse(npc, denizenPlayer, script, id, context);
            return new ChatContext(true);
        }
        if (npc.getCitizen().hasTrait(ChatbotTrait.class)) {
            Utilities.talkToNPC(message, denizenPlayer, npc, Settings.chatToNpcOverhearingRange());
            ((ChatbotTrait)npc.getCitizen().getTrait(ChatbotTrait.class)).chatTo((Entity)player, message);
            return new ChatContext(true);
        }
        if (!Settings.chatGloballyIfFailedChatTriggers()) {
            Utilities.talkToNPC(message, denizenPlayer, npc, Settings.chatToNpcOverhearingRange());
            return new ChatContext(true);
        }
        return new ChatContext(message, ret);
    }

    @EventHandler
    public void asyncChatTrigger(final AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!Settings.chatAsynchronous()) {
            return;
        }
        Callable<ChatContext> call = new Callable<ChatContext>(){
            ChatContext called = null;

            @Override
            public ChatContext call() {
                if (this.called != null) {
                    return this.called;
                }
                this.called = ChatTrigger.this.process(event.getPlayer(), event.getMessage());
                return this.called;
            }
        };
        Boolean cancelled = false;
        try {
            Boolean bl = cancelled = event.isAsynchronous() ? ((ChatContext)Bukkit.getScheduler().callSyncMethod((Plugin)DenizenAPI.getCurrentInstance(), (Callable)call).get()).wasTriggered() : ((ChatContext)call.call()).wasTriggered();
            if (((ChatContext)call.call()).hasChanges()) {
                event.setMessage(((ChatContext)call.call()).getChanges());
            }
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            dB.echoError(e);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        if (cancelled.booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void syncChatTrigger(PlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (Settings.chatAsynchronous()) {
            return;
        }
        ChatContext chat = this.process(event.getPlayer(), event.getMessage());
        if (chat.wasTriggered().booleanValue()) {
            event.setCancelled(true);
        }
        if (chat.hasChanges()) {
            event.setMessage(chat.getChanges());
        }
    }

    private boolean isKeywordRegex(String keyWord) {
        return keyWord.toUpperCase().startsWith("REGEX:");
    }

    private boolean isKeywordStrict(String keyWord) {
        return keyWord.toUpperCase().startsWith("STRICT:");
    }

    public class ChatContext {
        String changed_text;
        boolean triggered;

        public ChatContext(boolean triggered) {
            this.triggered = triggered;
        }

        public ChatContext(String changed_text, boolean triggered) {
            this.changed_text = changed_text;
            this.triggered = triggered;
        }

        public boolean hasChanges() {
            return this.changed_text != null;
        }

        public String getChanges() {
            return this.changed_text != null ? this.changed_text : DetermineCommand.DETERMINE_NONE;
        }

        public Boolean wasTriggered() {
            return this.triggered;
        }
    }
}

