/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.blocks;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.blocks.BlockData;
import net.aufdemrand.denizen.utilities.blocks.BlockSet;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.jnbt.ByteArrayTag;
import net.aufdemrand.denizen.utilities.jnbt.CompoundTag;
import net.aufdemrand.denizen.utilities.jnbt.IntTag;
import net.aufdemrand.denizen.utilities.jnbt.ListTag;
import net.aufdemrand.denizen.utilities.jnbt.NBTInputStream;
import net.aufdemrand.denizen.utilities.jnbt.NBTOutputStream;
import net.aufdemrand.denizen.utilities.jnbt.NamedTag;
import net.aufdemrand.denizen.utilities.jnbt.ShortTag;
import net.aufdemrand.denizen.utilities.jnbt.StringTag;
import net.aufdemrand.denizen.utilities.jnbt.Tag;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Location;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CuboidBlockSet
implements BlockSet {
    public List<BlockData> blocks = new ArrayList<BlockData>();
    public double x_width;
    public double y_length;
    public double z_height;
    public double center_x;
    public double center_y;
    public double center_z;

    public CuboidBlockSet() {
    }

    public CuboidBlockSet(dCuboid cuboid, Location center) {
        dLocation low = cuboid.pairs.get((int)0).low;
        dLocation high = cuboid.pairs.get((int)0).high;
        this.x_width = high.getX() - low.getX();
        this.y_length = high.getY() - low.getY();
        this.z_height = high.getZ() - low.getZ();
        this.center_x = center.getX() - low.getX();
        this.center_y = center.getY() - low.getY();
        this.center_z = center.getZ() - low.getZ();
        int x = 0;
        while ((double)x < this.x_width) {
            int y = 0;
            while ((double)y < this.y_length) {
                int z = 0;
                while ((double)z < this.z_height) {
                    this.blocks.add(new BlockData(low.clone().add((double)x, (double)y, (double)z).getBlock()));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    @Override
    public List<BlockData> getBlocks() {
        return this.blocks;
    }

    public dCuboid getCuboid(Location loc) {
        Location low = loc.clone().subtract(this.center_x, this.center_y, this.center_z);
        Location high = low.clone().add(this.x_width, this.y_length, this.z_height);
        return new dCuboid(low, high);
    }

    @Override
    public void setBlocks(Location loc) {
        int index = 0;
        int x = 0;
        while ((double)x < this.x_width) {
            int y = 0;
            while ((double)y < this.y_length) {
                int z = 0;
                while ((double)z < this.z_height) {
                    this.blocks.get(index).setBlock(loc.clone().add((double)x, (double)y, (double)z).getBlock());
                    ++index;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public CuboidBlockSet rotateOne() {
        return new CuboidBlockSet();
    }

    @Override
    public String toCompressedFormat() {
        StringBuilder sb = new StringBuilder(this.blocks.size() * 20);
        sb.append("cuboid:");
        sb.append(this.x_width).append(':').append(this.y_length).append(':').append(this.z_height).append(':');
        sb.append(this.center_x).append(':').append(this.center_y).append(':').append(this.center_z).append('\n');
        for (BlockData block : this.blocks) {
            sb.append(block.toCompressedFormat()).append('\n');
        }
        return sb.toString();
    }

    public BlockData blockAt(double X, double Y, double Z) {
        int index = 0;
        int x = 0;
        while ((double)x < this.x_width) {
            int y = 0;
            while ((double)y < this.y_length) {
                int z = 0;
                while ((double)z < this.z_height) {
                    if ((double)x == X && (double)y == Y && (double)z == Z) {
                        return this.blocks.get(index);
                    }
                    ++index;
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return null;
    }

    public static CuboidBlockSet fromCompressedString(String str) {
        CuboidBlockSet cbs = new CuboidBlockSet();
        List<String> split = CoreUtilities.split(str, '\n');
        List<String> details = CoreUtilities.split(split.get(0), ':');
        cbs.x_width = Double.parseDouble(details.get(1));
        cbs.y_length = Double.parseDouble(details.get(2));
        cbs.z_height = Double.parseDouble(details.get(3));
        cbs.center_x = Double.parseDouble(details.get(4));
        cbs.center_y = Double.parseDouble(details.get(5));
        cbs.center_z = Double.parseDouble(details.get(6));
        split.remove(0);
        for (String read : split) {
            if (read.length() <= 0) continue;
            cbs.blocks.add(BlockData.fromCompressedString(read));
        }
        return cbs;
    }

    public static CuboidBlockSet fromMCEditStream(InputStream is) {
        CuboidBlockSet cbs = new CuboidBlockSet();
        try {
            NBTInputStream nbtStream = new NBTInputStream(new GZIPInputStream(is));
            NamedTag rootTag = nbtStream.readNamedTag();
            nbtStream.close();
            if (!rootTag.getName().equals("Schematic")) {
                throw new Exception("Tag 'Schematic' does not exist or is not first!");
            }
            CompoundTag schematicTag = (CompoundTag)rootTag.getTag();
            Object schematic = schematicTag.getValue();
            int width = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "Width", ShortTag.class).getValue().shortValue();
            int length = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "Length", ShortTag.class).getValue().shortValue();
            int height = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "Height", ShortTag.class).getValue().shortValue();
            int originX = 0;
            int originY = 0;
            int originZ = 0;
            try {
                originX = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "WEOriginX", IntTag.class).getValue();
                originY = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "WEOriginY", IntTag.class).getValue();
                originZ = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "WEOriginZ", IntTag.class).getValue();
            }
            catch (Exception e) {
                // empty catch block
            }
            cbs.x_width = width;
            cbs.z_height = length;
            cbs.y_length = height;
            cbs.center_x = originX;
            cbs.center_y = originY;
            cbs.center_z = originZ;
            String materials = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "Materials", StringTag.class).getValue();
            if (!materials.equals("Alpha")) {
                throw new Exception("Schematic file is not an Alpha schematic!");
            }
            byte[] blockId = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "Blocks", ByteArrayTag.class).getValue();
            byte[] blockData = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "Data", ByteArrayTag.class).getValue();
            byte[] addId = new byte[]{};
            short[] blocks = new short[blockId.length];
            if (schematic.containsKey("AddBlocks")) {
                addId = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "AddBlocks", ByteArrayTag.class).getValue();
            }
            for (int index = 0; index < blockId.length; ++index) {
                blocks[index] = index >> 1 >= addId.length ? (short)(blockId[index] & 0xFF) : ((index & 1) == 0 ? (short)(((addId[index >> 1] & 0xF) << 8) + (blockId[index] & 0xFF)) : (short)(((addId[index >> 1] & 0xF0) << 4) + (blockId[index] & 0xFF)));
            }
            Object tileEntities = CuboidBlockSet.getChildTag((Map<String, Tag>)schematic, "TileEntities", ListTag.class).getValue();
            HashMap tileEntitiesMap = new HashMap();
            Iterator i$ = tileEntities.iterator();
            while (i$.hasNext()) {
                Tag tag = (Tag)i$.next();
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag t = (CompoundTag)tag;
                int x = 0;
                int y = 0;
                int z = 0;
                HashMap values = new HashMap();
                for (Map.Entry entry : t.getValue().entrySet()) {
                    if (((String)entry.getKey()).equals("x")) {
                        if (entry.getValue() instanceof IntTag) {
                            x = ((IntTag)entry.getValue()).getValue();
                        }
                    } else if (((String)entry.getKey()).equals("y")) {
                        if (entry.getValue() instanceof IntTag) {
                            y = ((IntTag)entry.getValue()).getValue();
                        }
                    } else if (((String)entry.getKey()).equals("z") && entry.getValue() instanceof IntTag) {
                        z = ((IntTag)entry.getValue()).getValue();
                    }
                    values.put(entry.getKey(), entry.getValue());
                }
                BlockVector vec = new BlockVector(x, y, z);
                tileEntitiesMap.put(vec, values);
            }
            Vector vec = new Vector(width, height, length);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int z = 0; z < length; ++z) {
                        int index = y * width * length + z * width + x;
                        BlockVector pt = new BlockVector(x, y, z);
                        BlockData block = new BlockData(blocks[index], blockData[index]);
                        if (tileEntitiesMap.containsKey(pt)) {
                            block.setNBTTag(new CompoundTag((Map)tileEntitiesMap.get(pt)));
                        }
                        cbs.blocks.add(block);
                    }
                }
            }
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return cbs;
    }

    private static <T extends Tag> T getChildTag(Map<String, Tag> items, String key, Class<T> expected) throws Exception {
        if (!items.containsKey(key)) {
            throw new Exception("Schematic file is missing a '" + key + "' tag");
        }
        Tag tag = items.get(key);
        if (!expected.isInstance(tag)) {
            throw new Exception(key + " tag is not of tag type " + expected.getName());
        }
        return (T)((Tag)expected.cast(tag));
    }

    public void saveMCEditFormatToStream(OutputStream os) {
        try {
            HashMap<String, Tag> schematic = new HashMap<String, Tag>();
            schematic.put("Width", new ShortTag((short)this.x_width));
            schematic.put("Length", new ShortTag((short)this.z_height));
            schematic.put("Height", new ShortTag((short)this.y_length));
            schematic.put("Materials", new StringTag("Alpha"));
            schematic.put("WEOriginX", new IntTag((int)this.center_x));
            schematic.put("WEOriginY", new IntTag((int)this.center_y));
            schematic.put("WEOriginZ", new IntTag((int)this.center_z));
            schematic.put("WEOffsetX", new IntTag(0));
            schematic.put("WEOffsetY", new IntTag(0));
            schematic.put("WEOffsetZ", new IntTag(0));
            byte[] blocks = new byte[(int)(this.x_width * this.y_length * this.z_height)];
            byte[] addBlocks = null;
            byte[] blockData = new byte[blocks.length];
            ArrayList<CompoundTag> tileEntities = new ArrayList<CompoundTag>();
            int indexer = 0;
            int x = 0;
            while ((double)x < this.x_width) {
                int y = 0;
                while ((double)y < this.y_length) {
                    int z = 0;
                    while ((double)z < this.z_height) {
                        int index = (int)((double)y * this.x_width * this.z_height + (double)z * this.x_width + (double)x);
                        BlockData bd = this.blocks.get(indexer);
                        ++indexer;
                        if (bd.material.getId() > 255) {
                            if (addBlocks == null) {
                                addBlocks = new byte[(blocks.length >> 1) + 1];
                            }
                            addBlocks[index >> 1] = (byte)((index & 1) == 0 ? addBlocks[index >> 1] & 0xF0 | bd.material.getId() >> 8 & 0xF : addBlocks[index >> 1] & 0xF | (bd.material.getId() >> 8 & 0xF) << 4);
                        }
                        blocks[index] = (byte)bd.material.getId();
                        blockData[index] = (byte)bd.data;
                        CompoundTag rawTag = bd.getNBTTag();
                        if (rawTag != null) {
                            HashMap<String, Tag> values = new HashMap<String, Tag>();
                            for (Map.Entry entry : rawTag.getValue().entrySet()) {
                                values.put((String)entry.getKey(), (Tag)entry.getValue());
                            }
                            values.put("id", new StringTag(null));
                            values.put("x", new IntTag(x));
                            values.put("y", new IntTag(y));
                            values.put("z", new IntTag(z));
                            CompoundTag tileEntityTag = new CompoundTag(values);
                            tileEntities.add(tileEntityTag);
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            schematic.put("Blocks", new ByteArrayTag(blocks));
            schematic.put("Data", new ByteArrayTag(blockData));
            schematic.put("Entities", new ListTag(CompoundTag.class, new ArrayList()));
            schematic.put("TileEntities", new ListTag(CompoundTag.class, tileEntities));
            if (addBlocks != null) {
                schematic.put("AddBlocks", new ByteArrayTag(addBlocks));
            }
            CompoundTag schematicTag = new CompoundTag(schematic);
            NBTOutputStream stream = new NBTOutputStream(new GZIPOutputStream(os));
            stream.writeNamedTag("Schematic", schematicTag);
            os.flush();
            stream.close();
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }
}

