/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.aufdemrand.denizen.objects.properties.item.ItemSkullskin;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.PlayerProfileEditor;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.DenizenCustomEntity;
import net.aufdemrand.denizen.utilities.entity.EntityFakePlayer;
import net.aufdemrand.denizen.utilities.packets.PacketHelper;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.minecraft.server.v1_8_R1.EntityHuman;
import net.minecraft.server.v1_8_R1.EntityPlayer;
import net.minecraft.server.v1_8_R1.EnumPlayerInfoAction;
import net.minecraft.server.v1_8_R1.Packet;
import net.minecraft.server.v1_8_R1.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_8_R1.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_8_R1.PlayerInteractManager;
import net.minecraft.server.v1_8_R1.World;
import net.minecraft.server.v1_8_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R1.CraftServer;
import org.bukkit.craftbukkit.v1_8_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CraftFakePlayer
extends CraftPlayer
implements DenizenCustomEntity {
    private final CraftServer server;

    public CraftFakePlayer(CraftServer server, EntityFakePlayer entity) {
        super(server, (EntityPlayer)entity);
        this.server = server;
        this.setMetadata("NPC", (MetadataValue)new FixedMetadataValue((Plugin)DenizenAPI.getCurrentInstance(), (Object)true));
    }

    @DenizenCustomEntity.CreateEntity
    public static Player createFakePlayer(Location location, ArrayList<Mechanism> mechanisms) {
        UUID uuid;
        String name = null;
        String skin = null;
        for (Mechanism mechanism : mechanisms) {
            if (mechanism.matches("name")) {
                name = mechanism.getValue().asString();
                continue;
            }
            if (!mechanism.matches("skin")) continue;
            skin = mechanism.getValue().asString();
        }
        if (name == null || name.length() > 16) {
            dB.echoError("You must specify a name with no more than 16 characters for FAKE_PLAYER names!");
            return null;
        }
        if (skin != null && skin.length() > 16) {
            dB.echoError("You must specify a name with no more than 16 characters for FAKE_PLAYER skins!");
        }
        CraftWorld world = (CraftWorld)location.getWorld();
        WorldServer worldServer = world.getHandle();
        GameProfile gameProfile = new GameProfile(null, name);
        gameProfile = ItemSkullskin.fillGameProfile(gameProfile);
        if (skin != null) {
            gameProfile = new GameProfile(gameProfile.getId(), gameProfile.getName());
            GameProfile skinProfile = new GameProfile(null, skin);
            skinProfile = ItemSkullskin.fillGameProfile(skinProfile);
            for (Property texture : skinProfile.getProperties().get((Object)"textures")) {
                gameProfile.getProperties().put((Object)"textures", (Object)texture);
            }
        }
        if ((uuid = UUID.randomUUID()).version() == 4) {
            long msb = uuid.getMostSignificantBits();
            msb &= 0xFFFFFFFFFFFFBFFFL;
            uuid = new UUID(msb |= 0x2000L, uuid.getLeastSignificantBits());
        }
        PlayerProfileEditor.setProfileId(gameProfile, uuid);
        final EntityFakePlayer fakePlayer = new EntityFakePlayer(worldServer.getMinecraftServer(), worldServer, gameProfile, new PlayerInteractManager((World)worldServer));
        fakePlayer.setPositionRotation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        new BukkitRunnable(){

            public void run() {
                PacketPlayOutNamedEntitySpawn spawnPacket = new PacketPlayOutNamedEntitySpawn((EntityHuman)fakePlayer);
                PacketPlayOutPlayerInfo playerInfo = new PacketPlayOutPlayerInfo(EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{fakePlayer});
                for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                    PacketHelper.sendPacket(player, (Packet)spawnPacket);
                    PacketHelper.sendPacket(player, (Packet)playerInfo);
                }
            }
        }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 5L);
        return fakePlayer.getBukkitEntity();
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getEntityMetadata().getMetadata((Object)this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getEntityMetadata().hasMetadata((Object)this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
    }

    @Override
    public String getEntityTypeName() {
        return "FAKE_PLAYER";
    }
}

