/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.entity;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.DenizenCustomEntity;
import net.aufdemrand.denizen.utilities.entity.Gravity;
import net.aufdemrand.denizencore.objects.Mechanism;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenizenEntityType {
    private static final Map<String, DenizenEntityType> registeredTypes = new HashMap<String, DenizenEntityType>();
    private final EntityType bukkitEntityType;
    private final String name;
    private final String lowercaseName;
    private final double gravity;
    private final Method createMethod;

    private DenizenEntityType(EntityType entityType) {
        this.bukkitEntityType = entityType;
        this.name = entityType.name();
        this.lowercaseName = this.name.toLowerCase();
        this.gravity = Gravity.getGravity(entityType);
        this.createMethod = null;
    }

    private DenizenEntityType(String name, Class<? extends DenizenCustomEntity> entityType) {
        this(name, entityType, 0.115);
    }

    private DenizenEntityType(String name, Class<? extends DenizenCustomEntity> entityType, double gravity) {
        EntityType bukkitEntityType = EntityType.UNKNOWN;
        if (entityType != null) {
            for (EntityType type : EntityType.values()) {
                Class clazz = type.getEntityClass();
                if (clazz == null || !clazz.isAssignableFrom(entityType)) continue;
                bukkitEntityType = type;
                break;
            }
        }
        this.bukkitEntityType = bukkitEntityType;
        this.name = name.toUpperCase();
        this.lowercaseName = name.toLowerCase();
        this.gravity = gravity;
        Method finalMethod = null;
        if (entityType != null) {
            for (Method method : entityType.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(DenizenCustomEntity.CreateEntity.class)) continue;
                finalMethod = method;
                break;
            }
        }
        this.createMethod = finalMethod;
    }

    public Entity spawnNewEntity(Location location, ArrayList<Mechanism> mechanisms) {
        try {
            if (this.name.equals("DROPPED_ITEM")) {
                return location.getWorld().dropItem(location, new ItemStack(Material.STONE));
            }
            if (!this.isCustom()) {
                return location.getWorld().spawnEntity(location, this.bukkitEntityType);
            }
            return (Entity)this.createMethod.invoke(null, location, mechanisms);
        }
        catch (Exception e) {
            dB.echoError(e);
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLowercaseName() {
        return this.lowercaseName;
    }

    public double getGravity() {
        return this.gravity;
    }

    public EntityType getBukkitEntityType() {
        return this.bukkitEntityType;
    }

    public static void registerEntityType(String name, Class<? extends DenizenCustomEntity> entityType) {
        registeredTypes.put(name.toUpperCase(), new DenizenEntityType(name, entityType));
    }

    public static boolean isRegistered(String name) {
        return registeredTypes.containsKey(name.toUpperCase());
    }

    public static DenizenEntityType getByName(String name) {
        return registeredTypes.get(name.toUpperCase());
    }

    public static DenizenEntityType getByEntity(Entity entity) {
        if (entity instanceof DenizenCustomEntity) {
            return DenizenEntityType.getByName(((DenizenCustomEntity)entity).getEntityTypeName());
        }
        return DenizenEntityType.getByName(entity.getType().name());
    }

    public boolean isCustom() {
        return this.createMethod != null;
    }

    static {
        for (EntityType entityType : EntityType.values()) {
            registeredTypes.put(entityType.name(), new DenizenEntityType(entityType));
        }
    }
}

