/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.entity;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.Set;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.entity.CraftFakePlayer;
import net.aufdemrand.denizen.utilities.entity.network.FakeNetworkManager;
import net.aufdemrand.denizen.utilities.entity.network.FakePlayerConnection;
import net.aufdemrand.denizen.utilities.packets.PacketHelper;
import net.minecraft.server.v1_8_R1.Entity;
import net.minecraft.server.v1_8_R1.EntityPlayer;
import net.minecraft.server.v1_8_R1.EntityTracker;
import net.minecraft.server.v1_8_R1.EntityTrackerEntry;
import net.minecraft.server.v1_8_R1.EnumGamemode;
import net.minecraft.server.v1_8_R1.EnumPlayerInfoAction;
import net.minecraft.server.v1_8_R1.EnumProtocolDirection;
import net.minecraft.server.v1_8_R1.MinecraftServer;
import net.minecraft.server.v1_8_R1.Packet;
import net.minecraft.server.v1_8_R1.PacketListener;
import net.minecraft.server.v1_8_R1.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_8_R1.PlayerInteractManager;
import net.minecraft.server.v1_8_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R1.CraftServer;
import org.bukkit.craftbukkit.v1_8_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EntityFakePlayer
extends EntityPlayer {
    private static final Field entryFlag;
    private static final Field trackerSet;

    public EntityFakePlayer(MinecraftServer minecraftserver, WorldServer worldserver, GameProfile gameprofile, PlayerInteractManager playerinteractmanager) {
        super(minecraftserver, worldserver, gameprofile, playerinteractmanager);
        playerinteractmanager.setGameMode(EnumGamemode.SURVIVAL);
        FakeNetworkManager networkManager = new FakeNetworkManager(EnumProtocolDirection.CLIENTBOUND);
        this.playerConnection = new FakePlayerConnection(minecraftserver, networkManager, this);
        networkManager.a((PacketListener)this.playerConnection);
        this.datawatcher.watch(10, (Object)127);
        this.bukkitEntity = new CraftFakePlayer((CraftServer)Bukkit.getServer(), this);
        worldserver.addEntity((Entity)this, CreatureSpawnEvent.SpawnReason.CUSTOM);
        EntityTrackerEntry entry = (EntityTrackerEntry)worldserver.getTracker().trackedEntities.get(this.getId());
        FakePlayerEntityTrackerEntry newEntry = new FakePlayerEntityTrackerEntry(entry);
        worldserver.getTracker().trackedEntities.a(this.getId(), (Object)newEntry);
        try {
            Set set = (Set)trackerSet.get(worldserver.getTracker());
            set.remove(entry);
            set.add(newEntry);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    public CraftFakePlayer getBukkitEntity() {
        return (CraftFakePlayer)this.bukkitEntity;
    }

    private static boolean getFlag(EntityTrackerEntry entry) {
        try {
            return entryFlag.getBoolean(entry);
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        Field entryFlagField = null;
        Field trackerSetField = null;
        try {
            entryFlagField = EntityTrackerEntry.class.getDeclaredField("u");
            entryFlagField.setAccessible(true);
            trackerSetField = EntityTracker.class.getDeclaredField("c");
            trackerSetField.setAccessible(true);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        entryFlag = entryFlagField;
        trackerSet = trackerSetField;
    }

    public class FakePlayerEntityTrackerEntry
    extends EntityTrackerEntry {
        public FakePlayerEntityTrackerEntry(EntityTrackerEntry entry) {
            super(entry.tracker, entry.b, entry.c, EntityFakePlayer.getFlag(entry));
        }

        public void updatePlayer(final EntityPlayer entityplayer) {
            if (entityplayer != this.tracker && this.c(entityplayer) && !this.trackedPlayers.contains(entityplayer) && (entityplayer.u().getPlayerChunkMap().a(entityplayer, this.tracker.ae, this.tracker.ag) || this.tracker.attachedToPlayer) && this.tracker instanceof EntityPlayer) {
                CraftPlayer player = ((EntityPlayer)this.tracker).getBukkitEntity();
                if (!entityplayer.getBukkitEntity().canSee((Player)player)) {
                    return;
                }
                final PacketPlayOutPlayerInfo[] playerListPacket = new PacketPlayOutPlayerInfo[]{new PacketPlayOutPlayerInfo(EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{(EntityPlayer)this.tracker})};
                PacketHelper.sendPacket((Player)entityplayer.getBukkitEntity(), (Packet)playerListPacket[0]);
                new BukkitRunnable(){

                    public void run() {
                        playerListPacket[0] = new PacketPlayOutPlayerInfo(EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{(EntityPlayer)FakePlayerEntityTrackerEntry.this.tracker});
                        PacketHelper.sendPacket((Player)entityplayer.getBukkitEntity(), (Packet)playerListPacket[0]);
                    }
                }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 2L);
            }
            super.updatePlayer(entityplayer);
        }
    }
}

