/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.minecraft.server.v1_8_R1.Entity;
import net.minecraft.server.v1_8_R1.EntityInsentient;
import net.minecraft.server.v1_8_R1.GenericAttributes;
import net.minecraft.server.v1_8_R1.NavigationAbstract;
import net.minecraft.server.v1_8_R1.PathEntity;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R1.entity.CraftEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class EntityMovement {
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();

    public static void stopFollowing(org.bukkit.entity.Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    public static void toggleAI(org.bukkit.entity.Entity entity, boolean hasAI) {
        Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        nmsEntity.getDataWatcher().watch(15, (Object)((byte)(!hasAI ? 1 : 0)));
    }

    public static boolean isAIDisabled(org.bukkit.entity.Entity entity) {
        Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return true;
        }
        return nmsEntity.getDataWatcher().getByte(15) != 0;
    }

    public static double getSpeed(org.bukkit.entity.Entity entity) {
        Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return 0.0;
        }
        EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        return nmsEntity.getAttributeInstance(GenericAttributes.d).getValue();
    }

    public static void setSpeed(org.bukkit.entity.Entity entity, double speed) {
        Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        nmsEntity.getAttributeInstance(GenericAttributes.d).setValue(speed);
    }

    public static void follow(final org.bukkit.entity.Entity target, final org.bukkit.entity.Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander) {
        if (target == null || follower == null) {
            return;
        }
        Entity nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsFollower = (EntityInsentient)nmsEntityFollower;
        final NavigationAbstract followerNavigation = nmsFollower.getNavigation();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0f);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation(targetLocation, follower.getLocation(), maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        follower.teleport(Utilities.getWalkableLocationNear(targetLocation, locationNearInt));
                    } else {
                        this.inRadius = false;
                        PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ());
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation(targetLocation, follower.getLocation(), lead)) {
                    PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ());
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.n();
                }
                nmsFollower.getAttributeInstance(GenericAttributes.d).setValue(speed);
            }
        }.runTaskTimer((Plugin)DenizenAPI.getCurrentInstance(), 0L, 20L));
    }

    public static void walkTo(final org.bukkit.entity.Entity entity, Location location, double speed, final Runnable callback) {
        if (entity == null || location == null) {
            return;
        }
        Entity nmsEntityEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntityEntity instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsEntity = (EntityInsentient)nmsEntityEntity;
        final NavigationAbstract followerNavigation = nmsEntity.getNavigation();
        final PathEntity path = followerNavigation.a(location.getX(), location.getY(), location.getZ());
        if (path != null) {
            final boolean aiDisabled = EntityMovement.isAIDisabled(entity);
            EntityMovement.toggleAI(entity, true);
            followerNavigation.a(path, 1.0);
            followerNavigation.a(2.0);
            final double oldSpeed = nmsEntity.getAttributeInstance(GenericAttributes.d).getValue();
            nmsEntity.getAttributeInstance(GenericAttributes.d).setValue(speed);
            new BukkitRunnable(){

                public void run() {
                    if (followerNavigation.m() || path.b()) {
                        if (callback != null) {
                            callback.run();
                        }
                        nmsEntity.getAttributeInstance(GenericAttributes.d).setValue(oldSpeed);
                        if (aiDisabled) {
                            EntityMovement.toggleAI(entity, false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)DenizenAPI.getCurrentInstance(), 1L, 1L);
        }
        if (!Utilities.checkLocation(location, entity.getLocation(), 20.0)) {
            entity.teleport(location);
        }
    }
}

